#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <forms.h>
#include "eyesim.h"
#include "protos.h"
/* #include "multi.h" */

BumpHandle bumpItLeft = 0, bumpItRight = 0;
BumpHandle BUMP_Sensor[MAX_ROBOTS][MaxNumOfBUMP];

BumpHandle BUMPInit(DeviceSemantics semantics)  {
  int i=0;
  if(!lcd_initialised)  
    InitialiseLCD();
  
  pthread_mutex_lock(&sem);
  if(!fl_form_is_visible(view->viewscreen)) 
    fl_show_form(view->viewscreen, FL_PLACE_FREE, FL_FULLBORDER, "View");
  pthread_mutex_unlock(&sem);
  if((semantics == BUMP_LEFT) && (bumpItLeft == 0)) {
    bumpItLeft = rand() % 10 + 1;
    i = bumpItLeft;
  }
  if ((semantics == BUMP_RIGHT) && (bumpItRight == 0))  {
    bumpItRight =  rand() % 10 + 11;
    i = bumpItLeft;
  }
  strcpy(BUMPinput[FIndex(pthread_self())],"BUMP (");
  if(bumpItLeft !=0)
    strcat(BUMPinput[FIndex(pthread_self())]," BUMP_LEFT");
  if (bumpItRight !=0);
    strcat(BUMPinput[FIndex(pthread_self())]," BUMP_RIGHT");
  strcat(BUMPinput[FIndex(pthread_self())]," )");
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return i;
}

int BUMPRelease(BumpHandle handle) {
  if((handle != bumpItLeft) && (handle != bumpItRight))  
    return -1;
  else if (handle == bumpItLeft)
    bumpItLeft = 0;
  else bumpItRight = 0;
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int BUMPCheck(BumpHandle handle, int *timestamp) {
  float thisAngle = 0;

  if((handle != bumpItLeft) && (handle != bumpItRight))
    return -1;
  if(stalled[FIndex(pthread_self())])  {
    if(handle == bumpItLeft)
      thisAngle = fabs(PI/2 + robot[FIndex(pthread_self())].radians - bumperAngle[FIndex(pthread_self())]);
    else
      thisAngle = fabs(-PI/2 + robot[FIndex(pthread_self())].radians - bumperAngle[FIndex(pthread_self())]);
    if(thisAngle > PI)
      thisAngle = fabs(2*PI - thisAngle);
    *timestamp = (int)(thisAngle*250.0); 
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return 0;
  } else {
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return 1;
  }
}

