/* Form definition file generated with fdesign. */

#include <stdio.h>
#include <string.h>
#include <forms.h>
#include <stdlib.h>
#include "errorChange.h"
#include "protos.h"
#include "eyesim.h"
// #include "multi.h"
 


FD_paramChange *create_form_paramChange(void)
{
  FL_OBJECT *obj;
  FD_paramChange *fdui = (FD_paramChange *) fl_calloc(1, sizeof(*fdui));

  pthread_mutex_lock(&sem);
  fdui->paramChange = fl_bgn_form(FL_NO_BOX, 450, 390);
  obj = fl_add_box(FL_UP_BOX,0,0,450,390,"");
  fdui->Forward = obj = fl_add_valslider(FL_HOR_BROWSER_SLIDER,180,20,230,30,"Forward velocity error");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,forward_cb,0);
  fdui->Rotate = obj = fl_add_valslider(FL_HOR_BROWSER_SLIDER,180,60,230,30,"Rotational velocity error");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,rotate_cb,0);
  fdui->Robot = obj = fl_add_input(FL_INT_INPUT,180,260,110,30,"Robot Size");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  fdui->Trail = obj = fl_add_input(FL_INT_INPUT,180,300,110,30,"Trail Buffer");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  fdui->psdBefore = obj = fl_add_input(FL_INT_INPUT,180,100,110,30,"PSD Sensor Range");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  fdui->psd_err = obj = fl_add_valslider(FL_HOR_BROWSER_SLIDER,180,140,230,30,"PSD Sensor Error");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
    fl_set_object_callback(obj,SIMpsd_cb,0);
  fdui->ir_err = obj = fl_add_valslider(FL_HOR_BROWSER_SLIDER,180,220,230,30,"Infra-red Sensor Error");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_LEFT);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
    fl_set_object_callback(obj,SIMir_cb,0);

  fdui->irMax = obj = fl_add_input(FL_INT_INPUT,180,180,110,30,"Infra-red range");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  fdui->psdAfter = obj = fl_add_input(FL_INT_INPUT,310,100,100,30,"to");
    fl_set_object_lstyle(obj,FL_BOLDITALIC_STYLE);
  obj = fl_add_button(FL_NORMAL_BUTTON,390,350,50,30,"Exit");
    fl_set_object_callback(obj,goback_cb,0);
  fl_end_form();

  fdui->paramChange->fdui = fdui;
  pthread_mutex_unlock(&sem);

  return fdui;
}
/*---------------------------------------*/

void forward_cb(FL_OBJECT *ob, long data)  {
  err_for = (double)(fl_get_slider_value(ob));
}

void rotate_cb(FL_OBJECT *ob, long data)  {
  err_rot = (double)(fl_get_slider_value(ob));
}

void SIMpsd_cb(FL_OBJECT *ob, long data)  {
  err_psd = (double)(fl_get_slider_value(ob));
}

void SIMir_cb(FL_OBJECT *ob, long data)  {
  err_ir = (double)(fl_get_slider_value(ob));
}

void goback_cb(FL_OBJECT *ob, long data)  {
  int i;

  sscanf(fl_get_input(errchange->psdBefore),"%d",&startPSD_);
  sscanf(fl_get_input(errchange->psdAfter), "%d" ,&i);
  endPSD_ = i - startPSD_;
  sscanf(fl_get_input(errchange->irMax),"%d",&IRrange);
  sscanf(fl_get_input(errchange->Robot),"%d",&i);
  ROBOT_RADIUS = i/2;
  sscanf(fl_get_input(errchange->Trail),"%d",&TrailBuffer);
  if(TrailBuffer > 20000)
    TrailBuffer = 20000;
  if(view->Pause->pushed != 0)
    dontMove = FALSE;
  fl_hide_form(errchange->paramChange);
  ftime(&stepTwo);
}
