#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>

#include "forms.h"
#include "eyesim.h"
#include "protos.h"
#include "LCDDisp.h"
#include "helpscreen.h"
#include "errorChange.h"
// #include "multi.h"
 
#define DegToRad 0.017453292   
#define DELETE_ROBOT	5

Segment *wld;
int NumSeg = 0, ROBOT_RADIUS = 75;
Robot robotStartPos[MAX_ROBOTS];
char fdata[50], tmp[50], tmp1[50];
Point stack[100];
struct timezone z;
BOOL dontMove = TRUE, helpBool = FALSE;
int dbg = 0;
void ContinuousPause();
void World(char *name);
void Maze(char *name);
void main();


void ClearScreen(void)  {
  // pthread_mutex_lock(&sem);
  fl_hide_object(help->showText);
  fl_set_object_label(help->title,"");
  fl_set_object_label(help->text,"");
  fl_winset(FL_ObjWin(help->text));
  fl_rectf(25,55,390,340,FL_COL1);
  // pthread_mutex_unlock(&sem);
}


/* callbacks and freeobj handles for form eyebot */
void B_Exit()
{  int i;

  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"EXIT button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button can used to quit the simulator. ");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    /* pthread_exit(0); */
    for(i=0;i<robot_count;i++)
      if(robot_id.index[i] == -1)
        pthread_kill(robot_id.r[i], SIGCONT);
    exit(0);
  }
}

void B_World()
{
  char *file;

  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"WORLD button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to load a `*.wld' file, which\n "
       "contains the dimensions of the world you select.\n"
       "Henceforth, the eyebot will be limited to the dimensions \n"
       "set by the current world.");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    sim_x = -1;
    // pthread_mutex_lock(&sem);
    fl_redraw_object(view->screen);
    file = (char *)fl_show_fselector("Load World", ".", "*.wld", "ee.4.wld");
    sim_x = -1;
    fl_redraw_object(view->screen);
    // pthread_mutex_unlock(&sem);
    World(file);
    sim_x = -1;
    // pthread_mutex_lock(&sem);
    fl_redraw_object(view->screen);
    // pthread_mutex_unlock(&sem);
  }
}


void World(char *file) {
  char ch;

  Segment tmpSeg;
  int cnt, pop;
  int pushed = 0;
  int tmpx, tmpy;
  FILE *fp;

  if (file == (char *)NULL)
    return;
  if ((fp = fopen(file,"r")) == NULL) {
    if (dbg) fprintf(stderr, "\nCannot open %s\n", file);
    return;
  }
  NumSeg = 0;
  if (wld != (Segment *)NULL)
    free(wld);
  while (!feof(fp)) {
    fscanf(fp, "%[^\n]", fdata);
    if (!feof(fp))
      fscanf(fp, "%c", &ch);
    if (*fdata != '\0') {
      cnt = 0;
      while (isspace(fdata[cnt]))
        cnt++;
      if (fdata[cnt] != ';') {
        if (!strncmp(fdata+cnt, "width", 5))
          sscanf(fdata+cnt, "%s %ld", tmp, &cState.map.w);
        else if (!strncmp(fdata+cnt, "height", 6))
          sscanf(fdata+cnt, "%s %ld", tmp, &cState.map.h);
        else if ((!strncmp(fdata+cnt, "push", 4))||(!strncmp(fdata+cnt,"change",6))) {
          sscanf(fdata+cnt, "%s %ld %ld %hd", tmp, &stack[pushed].x, &stack[pushed].y, \
                        &stack[pushed].theta);
          pushed++;
        } else if (!strncmp(fdata+cnt, "pop", 3)) {
          pushed--;
          if (pushed < 0) {
            if (dbg) fprintf(stderr, "Error in format: Excess Pop\n");
            return;
          }
        } else if (!strncmp(fdata+cnt, "position", 8)) {
          sscanf(fdata+cnt, "%s %d %d %f", tmp, &robot[0].x, &robot[0].y, \
                         &robot[0].radians);
          robot[0].radians = PI/180 * robot[0].radians;
          Y_rob_[0] = cState.map.h - robot[0].y;
 	  X_rob_[0] = robot[0].x;
	  robot[0].y = (int)Y_rob_;
          cState.map.x = robot[0].x - cState.w/2*cState.zoom;
          cState.map.y = robot[0].y - cState.h/2*cState.zoom;
        } else if (isdigit(fdata[cnt]) || (fdata[cnt] == '-')) {
          if (NumSeg)
            wld = (Segment *)realloc(wld, (NumSeg+1)*sizeof(Segment));
          else {
            NumSeg++;
            wld = (Segment *)malloc(2*sizeof(Segment));
          }
          sscanf(fdata+cnt, "%ld %ld %ld %ld", &wld[NumSeg].x1, &wld[NumSeg].y1, \
                        &wld[NumSeg].x2, &wld[NumSeg].y2);
          for(pop=pushed-1; pop>=0; pop--) {
            tmpx = wld[NumSeg].x1;
            tmpy = wld[NumSeg].y1;
            wld[NumSeg].x1 = (int)(stack[pop].x + tmpx*cos(DegToRad*stack[pop].theta) + \
                        tmpy*sin(DegToRad*stack[pop].theta));
            wld[NumSeg].y1 = (int)(stack[pop].y + tmpy*cos(DegToRad*stack[pop].theta) - \
                        tmpx*sin(DegToRad*stack[pop].theta));
            tmpx = wld[NumSeg].x2;
            tmpy = wld[NumSeg].y2;
            wld[NumSeg].x2 = (int)(stack[pop].x + tmpx*cos(DegToRad*stack[pop].theta) + \
                        tmpy*sin(DegToRad*stack[pop].theta));
            wld[NumSeg].y2 = (int)(stack[pop].y + tmpy*cos(DegToRad*stack[pop].theta) - \
                        tmpx*sin(DegToRad*stack[pop].theta));
          }
          if (wld[NumSeg].x2 < wld[NumSeg].x1) {
            tmpx = wld[NumSeg].x1;
            tmpy = wld[NumSeg].y1;
            wld[NumSeg].x1 = wld[NumSeg].x2;
            wld[NumSeg].y1 = cState.map.h-wld[NumSeg].y2;
            wld[NumSeg].x2 = tmpx;
            wld[NumSeg].y2 = cState.map.h-tmpy;
          }
          else {
            wld[NumSeg].y1 = cState.map.h-wld[NumSeg].y1;
            wld[NumSeg].y2 = cState.map.h-wld[NumSeg].y2;
          }
          NumSeg++;
        } else {
          if (dbg) fprintf(stderr, "Error in format: %s\n", fdata);
        }
      }
    }
    *fdata = '\0';
  }
  fclose(fp);
  for(cnt=2; cnt<NumSeg; cnt++) {
    pop = 1;
    while(pop != -1)
      if (wld[pop].x1 < wld[cnt].x1)
        pop = (cnt-pop > 1)? pop+1 : -1;
      else {
        memcpy(&tmpSeg, wld+cnt, sizeof(Segment));
        for(pushed=cnt; pushed>pop; pushed--)
          memcpy(wld+pushed, wld+pushed-1, sizeof(Segment));
        memcpy(wld+pop, &tmpSeg, sizeof(Segment));
        pop = -1;
      }
  }
  memcpy(wld,wld+1,sizeof(Segment));
  if (dbg) 
    for(cnt=0; cnt<NumSeg; cnt++)
      fprintf(stderr,"POS(%d) %ld %ld - %ld %ld\n",cnt,wld[cnt].x1,wld[cnt].y1,wld[cnt].x2, \
                        wld[cnt].y2);
  while((cState.map.w < (cState.w*cState.zoom)) || (cState.map.h < (cState.h*cState.zoom)))
    cState.zoom -= 0.5;
  if (cState.map.x < 0)
    cState.map.x = 0;
  else if((cState.map.x+cState.w*cState.zoom) > cState.map.w)
    cState.map.x = cState.map.w - cState.w*cState.zoom;
  if (cState.map.y < 0)
    cState.map.y = 0;
  else if((cState.map.y+cState.h*cState.zoom) > cState.map.h)
    cState.map.y = cState.map.h - cState.h*cState.zoom;
  VWSetPosition(hiddenVW[0],0,0,0);
/*    OSSemP(&sf);
    // pthread_mutex_lock(&sem);
    fl_check_forms();
    // pthread_mutex_unlock(&sem);
    OSSemV(&sf); */
    sim_x = -1;
    // pthread_mutex_lock(&sem);
    //fl_redraw_object(view->screen);
    // pthread_mutex_unlock(&sem);
}


void B_Maze() {
  char *file;

  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"MAZE button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to load a `*.maz' file, which\n "
       "is the maze map of the world to be loaded.\n"
       "Henceforth, the eyebot will be limited to the dimensions \n"
       "set by the current maze world. See eg1.maz for character \n"
       "to map size specification.\n"
       "Default is 400\n"		
       "\n"
       "'S' for starting position with wall directly underneath it\n"
       "'s' for starting position without.\n"
       "See eg2 for 's' usage\n");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    sim_x = -1;
    // pthread_mutex_lock(&sem);
    fl_redraw_object(view->screen);
    file = (char *)fl_show_fselector("Load Maze", ".", "*.maz", "");
    sim_x = -1;
    fl_redraw_object(view->screen);
    // pthread_mutex_unlock(&sem);
    Maze(file);
  }
}


void Maze(char *file) {
  int s, size;
  char ch;
  int i, j;
  int w = 0, h = 0, num_robs = 0, num_obs = 0;
  char **asc = NULL;
  FILE *fp;
  char tmp[75];
  Segment tmpSeg;

  if (file == (char *)NULL)
    return;
  if ((fp = fopen(file,"r")) == NULL) {
    if (dbg) fprintf(stderr, "\nCannot open %s\n", file);
    return;
  }
  OB_count = 0;
  size = 180;    
  while (!feof(fp)) {
    fscanf(fp, "%[^\n]", tmp);
    if (!feof(fp))
      fscanf(fp, "%c", &ch);
    if (isdigit(*tmp))   {
      size = atoi(tmp);
      size /= 2;
    } else {
      s = strlen(tmp)+1;
      if(h)
        asc = (char **)realloc(asc,(h+1)*sizeof(char *));
      else
        asc = (char **)malloc(sizeof(char *));
      asc[h] = (char *)malloc(sizeof(char)*s);
      memcpy(asc[h],tmp,s);
      if (s > w)
        w = s;
      h++;
    }
    *tmp = '\0';
  }
  cState.map.w = w*size*1.5;
  cState.map.h = h*size*2;
  for(i=0;i<h;i++) {
    s = strlen(asc[i]);
    asc[i] = (char *)realloc(asc[i],w*sizeof(char));
    if (w-1>s) {
      for(j=s;j<w;j++)
        asc[i][j] = ' ';
      asc[i][w-1] = '\0';
    }
  }
  i = 0;
  NumSeg = 0;
  if (wld != (Segment *)NULL)
    free(wld);
  while(i<h) {
    j = 0;
    while(j<w-1) {
      switch(asc[i][j]) {
        case '_': if ((j%2)&&((j==1)||((j>1)&&(asc[i][j-2]!='_')&&(asc[i][j-2]!='S')
                                &&(asc[i][j-2]!='s')))) {
                    s = j+2;
                    while((s<w-2)&&((asc[i][s]=='_')||(asc[i][s]=='S')||(asc[i][s]=='s')))
                      s+=2;
                    if (NumSeg)
                      wld = (Segment *)realloc(wld,(NumSeg+1)*sizeof(Segment));
                    else {
                      NumSeg++;
                      wld = (Segment *)malloc(2*sizeof(Segment));
                    }
                    wld[NumSeg].x1 = (j-1)*size+size;
                    wld[NumSeg].y1 = i*size*2+size;
                    wld[NumSeg].x2 = (s-1)*size+size;
                    wld[NumSeg].y2 = wld[NumSeg].y1;
                    NumSeg++;
                  }
                  break;
        case '|': if ((i>0)&&(asc[i-1][j] != '|')) {
                    s = i+1;
                    while((s<h)&&(asc[s][j] == '|'))
                      s++;
                    if (NumSeg)
                      wld = (Segment *)realloc(wld,(NumSeg+1)*sizeof(Segment));
                    else
                      wld = (Segment *)malloc(sizeof(Segment));
                    wld[NumSeg].x1 = j*size+size;
                    wld[NumSeg].y1 = (i-1)*size*2+size;
                    wld[NumSeg].x2 = wld[NumSeg].x1;
                    wld[NumSeg].y2 = (s-1)*size*2+size;
                    NumSeg++;
                  }
                  break;
        case 'U':
	case 'D':
	case 'L':
	case 'R':
        case 'S': if ((j%2)&&((j==1) ||((j>1)&&(asc[i][j-2]!='_')))) {
                    s = j+2;
                    while((s<w-2)&&(asc[i][s]=='_'))
                      s+=2;
                    if (NumSeg)
                      wld = (Segment *)realloc(wld,(NumSeg+1)*sizeof(Segment));
                    else {
                      NumSeg++;
                      wld = (Segment *)malloc(2*sizeof(Segment));
                    }
                    wld[NumSeg].x1 = (j-1)*size+size;
                    wld[NumSeg].y1 = i*size*2+size;
                    wld[NumSeg].x2 = (s-1)*size+size;
                    wld[NumSeg].y2 = wld[NumSeg].y1;
                    NumSeg++;
                  }
        case 'u':
	case 'd':
	case 'l':
	case 'r':
        case 's': if((num_robs < robot_count) || (robot_count == 0)) {
		  X_rob_[num_robs] = size*j+size;
                  Y_rob_[num_robs] = (i)*size*2;
		  robot[num_robs].x = size*j+size;
		  robot[num_robs].y = (i)*size*2;
	      	  if((asc[i][j] == 'r') || (asc[i][j] == 'R'))
		    robot[num_robs].radians = 0;
		  else if((asc[i][j] == 'L') || (asc[i][j] == 'l'))
		    robot[num_robs].radians = PI;
		  else if((asc[i][j] == 'd') || (asc[i][j] == 'D'))
		    robot[num_robs].radians = -PI/2;
		  else
	 	    robot[num_robs].radians = PI/2;
		  num_robs++;
		  }
                  break;
        case 'o':
                  if(num_obs < NumOfObstacles) {
		    OB_x[num_obs] = size*j+size;
		    OB_y[num_obs] = (i)*size*2;
		    num_obs++;
		    OB_count++;
		  }
		  break;
        case 'F':
        case 'f':
        case '.':
        case ' ': break;
        default : fprintf(stderr,"Undefined symbol %c\n",asc[i][j]);
                  break;
      }
      ++j;
    }
    i++;
  }
  fclose(fp);
  for(i=2; i<NumSeg; i++) {
    j = 1;
    while(j != -1)
      if (wld[j].x1 < wld[i].x1)
        j = (i-j > 1)? j+1 : -1;
      else {
        memcpy(&tmpSeg, wld+i, sizeof(Segment));
        for(s=i; s>j; s--)
          memcpy(wld+s, wld+s-1, sizeof(Segment));
        memcpy(wld+j, &tmpSeg, sizeof(Segment));
        j = -1;
      }
  }
  memcpy(wld,wld+1,sizeof(Segment));
  if (dbg)
    for(i=0; i<NumSeg; i++)
      fprintf(stderr, "POS(%d) %ld %ld - %ld %ld\n", i, wld[i].x1, wld[i].y1, wld[i].x2, \
                        wld[i].y2);
  while((cState.map.w < (cState.w*cState.zoom)) || (cState.map.h < (cState.h*cState.zoom)))
    cState.zoom -= 0.5;
  while((cState.map.w > (cState.w*cState.zoom)) || (cState.map.h > (cState.h*cState.zoom)))
    cState.zoom += 0.5;
  if (cState.map.x < 0)
    cState.map.x = 0;
  else if((cState.map.x+cState.w*cState.zoom) > cState.map.w)
    cState.map.x = cState.map.w - cState.w*cState.zoom;
  if (cState.map.y < 0)
    cState.map.y = 0;
  else if((cState.map.y+cState.h*cState.zoom) > cState.map.h)
    cState.map.y = cState.map.h - cState.h*cState.zoom;
  VWSetPosition(hiddenVW[0],0,0,0);
/*     OSSemP(&sf);
  // pthread_mutex_lock(&sem);
  fl_check_forms();
  // pthread_mutex_unlock(&sem);
  OSSemV(&sf); */
  sim_x = -1;
  // pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
}


void B_Param()
{
  char *file;

  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"PARAM button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to load a `*.p' file, which\n "
       "contains the parameters for the eyebot.\n\n"
       "Unfortunately, the parameter function has not yet\n"
       "been implemented and hence, you will not be able to\n"
       "load a param file.");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    sim_x = -1;
    // pthread_mutex_lock(&sem);
    fl_redraw_object(view->screen);
    file = (char *)fl_show_fselector("Load Param", ".", "*.p", "eyesim.p");
    sim_x = -1;
    fl_redraw_object(view->screen);
    // pthread_mutex_unlock(&sem);
    if (file != (char *)NULL)  
      Param(file);
  }
}


void Param(char *file) {
  char ch;
  char filename[50];
  int cnt, i, rcount=0;
  FILE *fp;

  if ((fp = fopen(file,"r")) == NULL) {
    if (dbg) fprintf(stderr, "\nCannot open %s\n", file);
    return;
  }

  NumOfIR = 0;
  NumOfPSD = 0;
  NumOfBUMP = 0;
  while (!feof(fp)) {
    fscanf(fp, "%[^\n]", fdata);
    if (!feof(fp))
      fscanf(fp, "%c", &ch);
    if (*fdata != '\0') {
      cnt = 0;
      while (isspace(fdata[cnt]))
        cnt++;

      if (fdata[cnt] != '#') {
        if (!strncmp(fdata+cnt, "name", 4))
          sscanf(fdata+cnt, "%s %s", tmp, name);
        else if (!strncmp(fdata+cnt, "diameter", 8)) {
          sscanf(fdata+cnt, "%s %d", tmp, &ROBOT_RADIUS);
          ROBOT_RADIUS /= 2;
        } else if (!strncmp(fdata+cnt, "speed", 5))
          sscanf(fdata+cnt, "%s %f", tmp, &vwLimit.v);
        else if (!strncmp(fdata+cnt, "turn", 4))
          sscanf(fdata+cnt, "%s %f", tmp, &vwLimit.w);
        else if (!strncmp(fdata+cnt, "world", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          World(filename);
        } else if (!strncmp(fdata+cnt, "maze", 4)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          Maze(filename);
        } else if (!strncmp(fdata+cnt, "debug", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          if (!strncmp(filename, "on", 2)) 
            dbg = 1;
          else if (!strncmp(filename, "off", 3)) 
            dbg = 0;
        } else if (!strncmp(fdata+cnt, "pause", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          if (strncmp(filename, "off", 3) == 0)  {
            dontMove = FALSE;
	    // pthread_mutex_lock(&sem);
 	    fl_set_button(view->Pause,1);
	    // pthread_mutex_unlock(&sem);
          }
        } else if (!strncmp(fdata+cnt, "psd", 3)) {
          if (NumOfPSD >= MaxNumOfPSD) {
            if (dbg) fprintf(stderr,"Exceed max. number of PSD sensors\n");
          } else {
            sscanf(fdata+cnt, "%s %s %d %lf %d %lf", tmp, PSDSen[0][NumOfPSD].name, \
			&PSDSen[0][NumOfPSD].semantic, &PSDSen[0][NumOfPSD].t,  &PSDSen[0][NumOfPSD].d,  &PSDSen[0][NumOfPSD].a);
            PSDSen[0][NumOfPSD].t *= DegToRad;
	    PSDSen[0][NumOfPSD].a *= DegToRad;
	    NumOfPSD++;
          } 
        } else if (!strncmp(fdata+cnt, "ir", 2)) {
          if (NumOfIR >= MaxNumOfIR) {
            if(dbg) fprintf(stderr,"Exceed max. number of IR sensors\n");
          } else {
            sscanf(fdata+cnt, "%s %s %d %lf %d %lf", tmp, IRSen[0][NumOfIR].name, 
                   &IRSen[0][NumOfIR].semantic, &IRSen[0][NumOfIR].t,
                   &IRSen[0][NumOfIR].d,  &IRSen[0][NumOfIR].a);
            IRSen[0][NumOfIR].t *= DegToRad;
            IRSen[0][NumOfIR].a *= DegToRad;
            NumOfIR++;
          }
        } else if (!strncmp(fdata+cnt, "bump", 4)) {
	   sscanf(fdata+cnt, "%s %s %d %lf %lf", tmp, BUMPSen[0][NumOfBUMP].name,
                  &BUMPSen[0][NumOfBUMP].semantic, &BUMPSen[0][NumOfBUMP].t,
                  &BUMPSen[0][NumOfBUMP].a);  
  	   BUMPSen[0][NumOfIR].t *= DegToRad;
  	   BUMPSen[0][NumOfIR].a *= DegToRad;
           NumOfBUMP++;
  	} else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"psd") != NULL))  {
	   sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
	   if(i>100)
	     i = 100;
           err_psd = (double)i/100;
  	} else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"ir") != NULL))  {
	   sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
	   if(i>100)
	     i = 100;
	   err_ir = (double)i/100;
  	} else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"line") != NULL))  {
	   sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
	   if(i>100)
	     i = 100;
	   err_for = (double)i/100;
  	} else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"rota") != NULL))  {
	   sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
	   if(i>100)
	     i = 100;
	   err_rot = (double)i/100;
        } else if (strstr(fdata+cnt,"robots") != NULL) {
           sscanf(fdata+cnt, "%s %d",tmp, &robot_id.Num_robot);
        } else if (strstr(fdata+cnt,"start") != NULL) {
           sscanf(fdata+cnt, "%s %f %f %f",tmp,  &(X_rob_[rcount]), &(Y_rob_[rcount]),
                                        &(robot[rcount].radians));
           robot[rcount].x = X_rob_[rcount];
           Y_rob_[rcount] = cState.map.h - Y_rob_[rcount];
           robot[rcount].y = Y_rob_[rcount];
           rcount++;
        }
        else {
           fprintf(stderr, "Error in format: %s\n", fdata);
        }
        *fdata = '\0';
      }
    }
  }
  fclose(fp); 
  sim_x = -1;
  // pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
}


void B_Zoom()
{
  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"ZOOM IN button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to enlarge the viewable map, \n "
       "allowing you to view the map in more detail. \n"
       "The zoom factor is currently set to 0.5, so the\n"
       "objects in the map are viewed in more detail by \n"
       "twenty percent. \n");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    if(cState.zoom >= 0.6) {
      cState.zoom -= 0.5;
      cState.map.x += (long)((robot[FIndex(pthread_self())].x-cState.map.x)*0.5/(cState.zoom+0.5));
      cState.map.y += (long)((robot[FIndex(pthread_self())].y-cState.map.y)*0.5/(cState.zoom+0.5));
    }
  }
  if (dbg) fprintf(stderr, "Zoom %2.1f\n", cState.zoom);
  sim_x = -1;
  // pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
}

void B_Unzoom()
{
  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"ZOOM OUT button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to shrink the viewable map, \n "
       "allowing you to view more of the map at a time. \n"
       "The zoom out factor is currently set to 0.5, so \n"
       "everytime you click the button, you see twenty percent\n"
       "more of the map.");
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    if((cState.map.h < (cState.h*cState.zoom)) && (cState.map.w < (cState.w*cState.zoom)))  {
      if (dbg) fprintf(stderr,"Maximum zoom out obtained\n");
    } else {
      cState.zoom += 0.5;
      cState.map.x -= (long)((robot[FIndex(pthread_self())].x-cState.map.x)*0.5/(cState.zoom-0.5));
      cState.map.y -= (long)((robot[FIndex(pthread_self())].y-cState.map.y)*0.5/(cState.zoom-0.5));
      if(cState.map.x<0)
        cState.map.x =0;
      else if((cState.map.x + cState.w*cState.zoom) > cState.map.w)
        cState.map.x = cState.map.w - cState.w*cState.zoom;
      if(cState.map.y < 0)
        cState.map.y = 0;
      else if((cState.map.y + cState.h*cState.zoom) > cState.map.h)
        cState.map.y = cState.map.h - cState.h*cState.zoom; 
  /*    OSSemP(&sf); */
      sim_x = -1;
      // pthread_mutex_lock(&sem);
      fl_redraw_object(view->screen);
      // pthread_mutex_unlock(&sem);
   /*   OSSemV(&sf); */
    }
  }
  if (dbg) fprintf(stderr, "Unzoom %2.1f\n", cState.zoom);
}

void menuCENTER(FL_OBJECT *ob, long data)
{ 
  if(helpBool)  {
    ClearScreen();
    /* // pthread_mutex_lock(&sem); */
    fl_set_object_label(help->title,"CENTER button.");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to center the map around the \n "
       "robot.  If the robot is too close to the edge of the\n"
       "map, it centers the map as close to the edge of the map\n"
       "possible.");
    XFlush(disp);
    /* // pthread_mutex_unlock(&sem); */
  } else {
    cState.map.x = robot[0].x - cState.w/2*cState.zoom;
    cState.map.y = robot[0].y - cState.h/2*cState.zoom;
    if (cState.map.x < 0) 
      cState.map.x = 0;
    else if((cState.map.x + cState.w*cState.zoom) > cState.map.w)
      cState.map.x = cState.map.w - cState.w*cState.zoom;
    if (cState.map.y < 0) 
      cState.map.y = 0;
    else if((cState.map.y + cState.h*cState.zoom) > cState.map.h)
      cState.map.y = cState.map.h - cState.h*cState.zoom;
    }
  if (dbg) fprintf(stderr, "Center\n");
  sim_x = -1;
  /* // pthread_mutex_lock(&sem); */
  fl_redraw_object(view->screen);
  /* // pthread_mutex_unlock(&sem); */
}

void B_Pause(FL_OBJECT *ob, long data)
{
  if(helpBool)  {
    ClearScreen();
    // pthread_mutex_lock(&sem);
    fl_set_object_label(help->title,"PAUSE button");
    fl_set_object_label(help->text,"\n\n\n"
       "This button is used to pause and unpause the whole\n "
       "simulator.  While the simulator is paused - you may\n"
       "still CENTER/ZOOM/UNZOOM the map and move the drag\n"
       "the robot to a different location using the mouse.");
    fl_set_button(view->Pause,0);
    fl_redraw_object(view->Pause);
    XFlush(disp);
    // pthread_mutex_unlock(&sem);
  } else {
    dontMove = !dontMove;
    ContinuousPause();
    gettimeofday(&checkOut,&z);
    //pthread_cond_broadcast(&pause_button);
  }
}

void ContinuousPause()  {
  while(dontMove) {  
    // pthread_mutex_lock(&sem);
    fl_check_forms();
    //pthread_mutex_unlock(&sem);
    gettimeofday(&checkOut,&z);
  }
  pthread_cond_broadcast(&pause_button);
}

void B_Screen(FL_OBJECT *ob, long data)
{
  if (dbg) fprintf(stderr, "Screen\n");
}

void B_Help(FL_OBJECT *ob, long data)  {
  dontMove = TRUE;
  // pthread_mutex_lock(&sem);
  fl_show_form(help->helpscreen, FL_PLACE_MOUSE, FL_FULLBORDER, "Help");
  // pthread_mutex_unlock(&sem);
  ClearScreen();
  // pthread_mutex_lock(&sem);
  fl_set_cursor(FL_ObjWin(fd_eyebot->LCDDisplay),XC_question_arrow);
  fl_set_cursor(FL_ObjWin(view->screen),XC_question_arrow);
  fl_set_object_label(help->title,"HELP");
  fl_set_object_label(help->text,"\n\n\n"
	"Click on any button within this window to use the help\n"
	"or else click on any other simulator button to have that\n"
	"particular button explained.\n\n"
	"About  - details about the simulator              \n"
	"Select - nothing right now...                             \n"
	"Search - search for a particular keyword        \n"
	"Index  - goto index to search for a keyword\n"
	"Exit   - quit the help                                       ");
  helpBool = TRUE;
  sim_x = -1;
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
  ContinuousPause();
}

void B_Refresh(FL_OBJECT *obj, long data)  {
  fl_redraw_form(view->viewscreen);
  sim_x = -1;
  // pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
}

void menuFILE(FL_OBJECT *ob, long data)  {
  int i;
  char *tempstr;
 
  // pthread_mutex_lock(&sem);
  i = fl_get_menu(ob);
  // pthread_mutex_unlock(&sem);
  switch(i)  {
  case 1:
    B_World();
    break;
  case 2:
    B_Maze();
    break;
  case 3:
    B_Param();
    break;
  case 4:
    dontMove = TRUE;
    tempstr = (char *)calloc(40,sizeof(char));
    sprintf(tempstr,"%d",2*ROBOT_RADIUS);
    // pthread_mutex_lock(&sem);
    fl_set_input(errchange->Robot,tempstr);
    sprintf(tempstr,"%d",startPSD_);
    fl_set_input(errchange->psdBefore,tempstr);
    sprintf(tempstr,"%d",startPSD_ + endPSD_);
    fl_set_input(errchange->psdAfter,tempstr);
    sprintf(tempstr,"%d",IRrange);
    fl_set_slider_value(errchange->Forward,(double)err_for);
    fl_set_slider_value(errchange->Rotate,(double)err_rot);
    fl_set_slider_value(errchange->ir_err,(double)err_ir);
    fl_set_slider_value(errchange->psd_err,(double)err_psd);
    fl_set_input(errchange->irMax,tempstr);
    sprintf(tempstr,"%d",TrailBuffer);
    fl_set_input(errchange->Trail,tempstr);
    fl_show_form(errchange->paramChange, FL_PLACE_MOUSE,FL_FULLBORDER,"Parameters");
    // pthread_mutex_unlock(&sem);
    ContinuousPause();
    break;
  case 5:
    B_Exit();
    break;
  default: break;
  }
  sim_x = -1;
  // pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  // pthread_mutex_unlock(&sem);
}

void menuGROW(FL_OBJECT *ob, long data)  {
  int i, j;

  i = fl_get_menu(ob);
  switch(i)  {
  case 1:
    if(dontMove)  {
      robot_id.Num_robot++;
      pthread_create(&(robot_id.r[robot_id.Num_robot-1]), &thread_attr,
	(void *)&main, NULL);
      fprintf(stderr, "Robot placed on the screen\n");
      robot[robot_id.Num_robot-1].radians = 0.0;
      X_rob_[robot_id.Num_robot-1] = 100 + ROBOT_RADIUS + cState.map.y;
      Y_rob_[robot_id.Num_robot-1] = 100 + ROBOT_RADIUS + cState.map.y;
      robot[robot_id.Num_robot-1].x = X_rob_[robot_id.Num_robot-1];
      robot[robot_id.Num_robot-1].y = Y_rob_[robot_id.Num_robot-1];
    }
    break;
  case 2:
    if(dontMove)
      cState.mouse = DELETE_ROBOT;
    break;
  case 3:
    trail = 1;
    break;
  case 4:
    trail = 0;
    for(j=0;j<MAX_ROBOTS;j++)
      counter[j] = 0;
    break;
  default: 
    sim_x = -1;
    fl_redraw_object(view->screen);
    break;
  }
  sim_x = -1;
  fl_redraw_object(view->screen);
}

void menuSHRINK(FL_OBJECT *ob, long data)  {
  int i;

  i = fl_get_menu(ob);
  switch(i)  {
  case 1:
    B_Zoom();
    break;
  case 2:
    B_Unzoom();
    break;
  case 3:
    while((cState.map.w > (cState.w*cState.zoom)) || (cState.map.h > (cState.h*cState.zoom)))
      cState.zoom += 0.5;
    menuCENTER(view->Center,0);
    break;
  default: 
    sim_x = -1;
    fl_redraw_object(view->screen);
    break;
  }
  sim_x = -1;
  fl_redraw_object(view->screen);
}

