/* 	$Id: eyesim.h,v 1.1 1999/11/13 14:24:49 pere Exp $	 */

#ifndef FD_eyebot_h_
#define FD_eyebot_h_
#include "types.h"
#include "viewscreen.h"
#define ROBOT_PSCALE 0.2
#define MAX_ROBOTS 100


typedef struct {
  long x1;
  long y1;
  long x2;
  long y2;
} Segment;

typedef struct {
  long x;
  long y;
} Points;

typedef struct {
  long x;
  long y;
  short theta;
} Point;

typedef struct {
  int x, y;
  float radians;
} Robot;

typedef struct {
  long x, y, lx, ly;
  long w, h;
} Map;

typedef struct {
  int x, y, w, h;
  int mx, my;
  int b1, b2, b3;
  int mouse;
  float zoom;
  Map map;
} State;

extern State cState;
extern Robot robot[MAX_ROBOTS];
extern Segment *wld;
extern int NumSeg, ROBOT_RADIUS;
extern float  rot_error, for_error;
extern Robot robotStartPos[MAX_ROBOTS];
extern long mapWidth, mapHeight;
extern FD_viewscreen *view;
extern BOOL dontMove, helpBool;
/* extern XSegment *visible;
extern NSegVisible;
*/

/** External functions **/

extern float SIMsqr(float);

/** Callback routines and free object handlers **/


extern void ClearScreen();
extern XSegment *Filter(int *);

#endif /* FD_eyebot_h_ */









