#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <forms.h>
#include <math.h>
#include <ctype.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>

#include "LCDDisp.h"
#include "protos.h"
#include "qcam.h"
#include "improc.h"
#include "eyesim.h"
#include "helpscreen.h"

Display * disp;
Window  win;
XGCValues values;
Colormap cmap;
XImage *ximage;
BYTE ximagemem[IMAGE_SIZE*4];
GC gc;
int screen_num, xDepth, imageSize = IMAGE_SIZE;
int colortable[64];
struct timezone z;
int keystatus, scrolling, lcdline, lcdpos;
char **text, *compareinput, *BUMPinput[MAX_ROBOTS], *PSDinput;
FD_EyeBotLCD *fd_eyebot;
float bumperAngle[MAX_ROBOTS];
BOOL **lcdpixel, lcd_initialised = FALSE, stalled[MAX_ROBOTS];


void DoText()  {
  pthread_mutex_lock(&sem);
  fl_set_object_lcol(view->screenText,FL_COL1);
  strcpy(sText[0],"X  Y  PHI\n");
  strcat(sText[0],PSDinput);
  strcat(sText[0],"\n");
  strcat(sText[0],IRinput[0]);
  strcat(sText[0],"\n");
  strcat(sText[0],BUMPinput[0]);
  fl_set_object_label(view->screenText,sText[0]);
  fl_set_object_lcol(view->screenText,FL_BLACK);
  pthread_mutex_unlock(&sem);
}

int OSGetAD(int mode){
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int AUCaptureMic() {
  int i;
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  i = rand() % 500;
  return i;
}

int AUCheckTone() {return 1;}

int AUBeep() {
  pthread_mutex_lock(&sem);
  fl_ringbell(0);
  pthread_mutex_unlock(&sem);
  return 0;
}
  

int NewImage(int w, int h)
{
    if (ximage == NULL || w != ximage -> width || h != ximage -> height)
    {
        if (ximage != NULL)
            XDestroyImage(ximage);

        ximage = XCreateImage(disp,
                              DefaultVisual(disp,screen_num),
                              xDepth,
                              ZPixmap,
                              0,
                              &ximagemem[0],
                              w,
                              h,
                              8,
                              0);
        return 1;
    }

    return 0;
}

void (*RawToX)();

int printf(const char *format, ...)  {
  char *test;
  int count, other;
  va_list vargs;

  test = (char *)calloc(1024,sizeof(char));
  va_start(vargs,format);
  count = vsprintf(test,format,vargs);
  other = LCDPutString(test);
  va_end(vargs);
  return count;
}


void KEY_cb(FL_OBJECT *ob, long data)  {
  char *t;
  if(helpBool)  {
    ClearScreen();
    t = (char *)calloc(40,sizeof(char));
    sprintf(t,"KEY %d button",1+(int)(log10(1+data)/log10(4)));
    fl_set_object_label(help->title,t);
    fl_set_object_label(help->text,"\n\n\n"
        "These buttons may be used for user input if your\n."
 	"program supports it.  From left to right, the keys\n"
	"represent KEY1, KEY2, KEY3 and KEY4.");
  } else
    keystatus = data;
}

void POWEROFF(FL_OBJECT *ob, long data)  {
  if(helpBool)  {
    ClearScreen();
    fl_set_object_label(help->title,"EXIT button");
    fl_set_object_label(help->text,"\n\n\n"
        "This button is used to quit from the simulator.");
    fl_set_button(fd_eyebot->POWER,0);
    fl_redraw_object(fd_eyebot->POWER);
  } else {
    if((scrolling & (GRAPHICS >> 1)) != 0)  {
      CAMSIM_exit();
    }
    exit(0);
  }
}

void RESET_cb(FL_OBJECT *ob, long data)  {
  if(helpBool)  {
    ClearScreen();
    fl_set_object_label(help->title,"RESET button");
    fl_set_object_label(help->text,"\n\n\n"
        "This button currently only clears the LCD Display.");
  } else
    LCDClear();
}

void RawTo8BitX(BYTE * raw, BYTE * xbuf)
{
    int i;

    for(i = 0; i < imageSize; i++)
        *xbuf++ = colortable[(int)*raw++];
}

void RawTo24BitX(BYTE * raw, int * xbuf)
{
    int i;
    int c;

    for(i = 0; i < imageSize; i++)
    {
        c = (int)*raw++;
        *xbuf++ = c;
    }
}

void xqc_createpalette(Colormap cmap)
{
    int i;
    int rc;
    XColor col;

    for(i = 0; i < 16; i++)
    {
        col.red =col.green = col.blue = i * 1024 * 4;
        rc = XAllocColor(disp, cmap, &col);
        colortable[i] = col.pixel;
        /* fprintf(stdout, "rc=%d %08lX\n", rc, col.pixel);*/
    }


    return;
}

void exit_cb(FL_OBJECT *ob, long data)  {
  helpBool = FALSE;
  if(view->Pause->pushed != 0)
    dontMove = FALSE;
  fl_set_cursor(FL_ObjWin(fd_eyebot->LCDDisplay),XC_arrow);
  fl_set_cursor(FL_ObjWin(view->screen),XC_arrow);
  ClearScreen();
  fl_hide_form(help->helpscreen);
  gettimeofday(&checkOut,&z);
}

void about_cb(FL_OBJECT *ob, long data)  {
  ClearScreen();

  fl_set_object_label(help->title,"Eyebot Simulator");
  fl_set_object_label(help->text,"\n\n\n"
    "XSIM - XWindows Robot Simulator\n"
    "version 1.1 21/01/98\n"
    "\nby Nicholas Tay (tay-nt@ee.uwa.edu.au)\n"
    "   Ghee Heng Ong (ong-g@ee.uwa.edu.au)\n"
    "   Elliot Nicholls (nicho-ej@ee.uwa.edu.au)\n"
    "\nSupervisor : Thomas Braunl (braunl@ee.uwa.edu.au)");
}

void search_cb(FL_OBJECT *ob, long data)  {
  ClearScreen();
  /*strncpy(compareinput,"\0",100);*/
  fl_show_object(help->inputfield);
  fl_set_object_label(help->title,"Search");
  fl_set_object_label(help->text,"\n\n\n\n"
    "Search enables you to search for specific words and        \n"
    "phrases in help topics instead of browsing for information\n"
    "by category (Index).                                                             \n\n\n"
    "The search is not case specific so typing UPPER case      \n"
    "characters are not necessary, nor will it affect the                \n"
    "search                                                                                                \n"
    "\n\n\n\n"
    "Input text to search and press ENTER");
  fl_set_input(help->inputfield,"");  
}

void index_cb(FL_OBJECT *ob, long data)  {
}

void select_cb(FL_OBJECT *ob, long data)  {
}

int AUTone(int freq, int msec)  {
  char *tempstr;

  tempstr = (char *)calloc(40,sizeof(char));
  sprintf(tempstr,"tones %d %d",msec,freq);
  system(tempstr);
  return 0;
}

