#ifndef  HDT_H
#define  HDT_H

#include "types.h"

/* HDT = hardware description table */

typedef short   TypeID;
typedef short   DeviceSemantics;
typedef int     (*TestFunc) (DeviceSemantics);
typedef char    String6[7];
typedef char    String10[11];

/* prototypes */

int HDT_Validate(void);
void *HDT_FindEntry(TypeID,DeviceSemantics);
DeviceSemantics  HDT_FindSemantics(TypeID , int);
int   HDT_TypeCount(TypeID);
char* HDT_GetString(TypeID, DeviceSemantics);

/* DTL entry structure */
/*---------------------------------------------------------------------------------*/
typedef struct
{
    TypeID      group;
    String6     name;
    TestFunc    testfunc;
} DTL_entry_type;

/* HDT entry structure */
/*---------------------------------------------------------------------------------*/
typedef struct
{
    TypeID              typeid;
    DeviceSemantics     semantics;
    String6             device_name;
    void*               data_area;
} HDT_entry_type;

/* hardware description structures */
/*---------------------------------------------------------------------------------*/
typedef struct
{
	int     driver_version;
	int     tpu_channel;
	int     tpu_timer;
	int     pwm_period;
	BYTE*   out_pin_address;
	short   out_pin_fbit;
	short   out_pin_bbit;
    BYTE*   conv_table;     /* NULL if no conversion needed */
}motor_type;

typedef struct
{
	int     driver_version;
	int     master_tpu_channel;
	int     slave_tpu_channel;
    DeviceSemantics motor;  /* connected motor */
    unsigned int clicksPerMeter; /* needed for VW-Interface and odometer */
    float   maxspeed;       /* (in m/s) only needed for VW-Interface */
}quad_type;


typedef struct
{
	int     driver_version;
	int     tpu_channel;
	int     tpu_timer;
	int     pwm_period;
    int     pwm_start;
    int     pwm_stop;
}servo_type;


typedef struct
{
    int     driver_version;
    int     tpu_channel;
    int     tpu_timer;
    short   transition;
}bump_type;

typedef struct
{
    int     driver_version;
    int     tpu_channel;
}ir_type;

typedef struct
{
	short   driver_version;
	short   tpu_channel;
	BYTE*   in_pin_address;
	short   in_pin_bit;
	short   in_logic;
	BYTE*   out_pin_address;
	short   out_pin_bit;
	short   out_logic;
	short*  dist_table;
}psd_type;

typedef struct
{
	int     version;
	int     id;                     /* id must be on this position */
	int     serspeed;
	int     handshake;
	int     interface;
	int     res1;
	int     res2;
	int     cammode;
    int     battery_display;
    int     CPUclock;
    float   user_version;
    String10 name;
    unsigned char robi_id;
}info_type;

typedef struct
{
	short     version;
	short     rom_ws;
	short     ram_ws;
	short     lcd_ws;
	short     io_ws;
	short     serpar_ws;
}waitstate_type;


#define DIFFERENTIAL_DRIVE 0
#define ACKERMAN_DRIVE 1
#define SYNCHRO_DRIVE 2
#define TRICYCLE_DRIVE 3

typedef struct
{
    DeviceSemantics quad_left;
    DeviceSemantics quad_right;
    float           wheel_dist; /* meters */
}diff_data;

/* acker_data is not used by now! It's just an example for an implementation */
typedef struct
{
    DeviceSemantics quad_steer;
    DeviceSemantics quad_drive;
    float           steerwheel_dist; /* meters */
    float           drivewheel_dist; /* meters */
	float			axes_dist;       /* meters */
}acker_data;

typedef union
{
    diff_data   diff;
    acker_data  acker;
}drvspec;

typedef struct
{
	int     version;
    int     drive_type;
    drvspec drive_spec;
}vw_type;

/* Handle structure */
/*----------------------------------------------------------------------------------*/
typedef int MotorHandle;

typedef int ServoHandle;

typedef int PSDHandle;

typedef int QuadHandle;

typedef int BumpHandle;

typedef int IRHandle;

typedef int VWHandle;
/****************************************************************************/
/*  Constantsdefinition                                                       */
/****************************************************************************/

/* for TPU */

#define TIMER1 1
#define TIMER2 2

/* for INFO */

#define PLATFORM 0
#define VEHICLE 1
#define WALKER 2

#define BATTERY_OFF 0
#define BATTERY_ON 1

/* for Bumper */
#define RISING  0x7
#define FALLING 0xB
#define EITHER  0xF

/* misc */

#define AH  0
#define AL  1

/**************************************************************************/
/*  TypeID-constants, for type of device                                      */
/**************************************************************************/

#define UNKNOWN_TYPE   0
#define END_OF_HDT     -1
#define CHECKSUM       -2

#define MOTOR          -100
#define PSD            -200
#define SERVO          -300
#define QUAD           -400
#define BUMP           -500
#define IR             -600
#define VW             -700
#define INFO           -10000
#define WAIT           -11000
#define DATA           -30000

#define     UNKNOWN_SEMANTICS    0
                                   
#endif



