
/*
 *   Image Processing Library
 *   Thomas Braunl, Univ. Stuttgart, 1996
 *   Additional Code by Gerrit Heitsch
 *   Adapted by Michael Rudolph
 *   derived after Braunl et al. : Parallele Bildverarbeitung, Addison-Wesley
 *
 *   $Id: improc.h,v 1.1.1.1 1999/10/21 09:20:30 pere Exp $
 *
 */

#if !defined(_IPL_IMPROC_H)
#define _IPL_IMPROC_H


#if defined (__cplusplus)
extern "C" {
#endif


#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif

#if defined(IMPLEMENT_IPL)
#define MAX_IMAGE_SIZE (320*240)
#define MAX_CONTOUR  1000
#endif

/*
 *    image processing library configuration structure
 */

typedef struct
{
    int imageWidth;
    int imageHeight;
    int colorBlack;
    int colorWhite;
} IPL_CONFIG;


typedef struct
{
    short x;
    short y;
} IPLPoint;

typedef struct
{
    double x;
    double y;
} XYDistance;


/*
 *    Die global sichtbaren Funktionen der Image Processing Library
 *    Sie beginnen alle mit IPL_, um name clashes zu vermeiden.
 */

#if defined (__cplusplus)
}
#endif

extern void IPInit(IPL_CONFIG *);

#endif
