/********************************************************************************
 * Functions:									*
 * IRHandle IRInit(DeviceSemantics)	| Initialise specific IR Handler	*
 * int IRRelease(IRHandle)		| Release specific IR Handler		*
 * int IRRead(IRHandle)  		| Reads in specific IR			*
 ********************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <forms.h>
#include "protos.h"
#include "viewscreen.h"
// #include "multi.h"
 

int IRrange, IRcount = 0;


IRHandle IRInit(DeviceSemantics semantics)  {
  int IRsem = -semantics+IR, j = 0, i;
  if(!lcd_initialised)  
    InitialiseLCD();
  if(robot_count != robot_id.Num_robot)
      ThreadFork();

  pthread_mutex_lock(&sem);
  if(!fl_form_is_visible(view->viewscreen))  
    fl_show_form(view->viewscreen, FL_PLACE_FREE, FL_FULLBORDER, "View");
  pthread_mutex_unlock(&sem);

  while ((IRsem >= 0) && (j < NumOfIR))  {
    if (IR_Sensor[FIndex(pthread_self())][j] == 0) {
if(semantics == IRSen[FIndex(pthread_self())][j].semantic)  {
      IR_Sensor[FIndex(pthread_self())][j] = rand()%10 + 201 + 10*IRsem;
      IRinput[FIndex(pthread_self())][strlen(IRinput[FIndex(pthread_self())])-1] = '\0';
      IRcount++;
      pthread_mutex_lock(&sem);
      fl_winset(FL_ObjWin(view->screenText));
      fl_rectf(view->screenText->x+1,view->screenText->y+1,view->screenText->w-2,view->screenText->h-2,FL_COL1);
      pthread_mutex_unlock(&sem);
      strcpy(IRinput[FIndex(pthread_self())],"IR (");
      for(i=0;i<NumOfIR;i++)  
        if(IR_Sensor[FIndex(pthread_self())][i]) {
	  strcat(IRinput[FIndex(pthread_self())]," "); 
	  strcat(IRinput[FIndex(pthread_self())],IRSen[FIndex(pthread_self())][i].name); 
        }
      strcat(IRinput[FIndex(pthread_self())]," )");
      DoText();
      return IR_Sensor[FIndex(pthread_self())][j];
}
    } 
    j++;
  }
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}


int IRRelease(IRHandle handle) {
  int i;
  
  for(i=0; i<NumOfIR; i++)
    if (handle == IR_Sensor[FIndex(pthread_self())][i]) {
      IRcount--;
      IR_Sensor[FIndex(pthread_self())][i] = 0;
      OSSemP(&sf);
      pthread_mutex_lock(&sem);
      fl_check_forms();
      fl_redraw_object(view->screen);
      pthread_mutex_unlock(&sem);
      OSSemV(&sf);
      return 0;
    }
  fprintf(stderr, "IR not found\n");
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return -1;
}

int IRRead(IRHandle handle) {
  int i = 0;

  if (handle == 0) {
    fprintf(stderr, "IR not initialised\n");
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return -1;
  }

  while((i < NumOfIR) && (handle != IR_Sensor[FIndex(pthread_self())][i])) 
    i++; 
  if(i == NumOfIR) {
    fprintf(stderr, "IR not found\n");
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return -1;
  }
  //OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  //OSSemV(&sf);
  return IR_detect[FIndex(pthread_self())][i];
}


