/*---------------------------------------------------------------------------
- | Filename: keysim.c
|
| Author:	Nicholas Tay (tay-nt@ee.uwa.edu.au)
|
| Description: 
| key input routines
|
| KEY.... routines are callable from C 
|------------------------------------------------------------------------------
| Functions:
| int KEYGetBuf (char *buf);		| wait for keypress an store code in
|					| (buf)
| int KEYGet (void);			| wait for keypress and return 
|					| keycode
| int KEYRead (void);			| read the current keycode
| int KEYWait (int expectedkeycode);	| wait for specific key
L----------------------------------------------------------------------------*/

#include "forms.h"
#include "protos.h"
#include "viewscreen.h"

/* KEYGet:
		| ------------------------------------------------------
		| Description: 
		| wait for a pressed key and return keycode
		| ------------------------------------------------------
		| Input:	NONE
		|
		| Output:       keycode
		| ----------------------------------------------------*/

int KEYGet(void)  {
	
  int i;
  
  if(!lcd_initialised)
    InitialiseLCD();  
  while((keystatus & 85) == 0) {
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
  }
  i = keystatus;
  keystatus = 0;	/* Reset keystatus */
  return i;
}

/* KEYGetBuf:
		| ------------------------------------------------------
		| Description: 
		| wait for a pressed key and store keycode 
		| ------------------------------------------------------
		| Input: 	buf	pointer to keycode buffer
		|
		| Output: 	(buf)	keycode
		| ----------------------------------------------------*/

int KEYGetBuf(char *buf)  {

  if(!lcd_initialised)
    InitialiseLCD();  
  while((keystatus & 85) == 0) {
    /* 85 is mask for all KEYS */
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
  }
  *buf = (char)keystatus;
  keystatus = 0;
  return *buf;
}

/* KEYWait:
		| ------------------------------------------------------
		| Description: 
		| wait for a specific pressed key and return keycode
		| ------------------------------------------------------
		| Input:      expectedkeycode	expected keycode (0 for anykey)
		|
		| Output:     keycode
		| ----------------------------------------------------*/

int KEYWait(int expectedkeycode) {

  int i;
  if(!lcd_initialised)
    InitialiseLCD();  
  if (expectedkeycode == 0)
    expectedkeycode = 85;
  while((keystatus & expectedkeycode) == 0) {
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
  }
  i = keystatus;
  keystatus = 0;
  return i;
}


/*KEYRead:
		| ------------------------------------------------------
		| Description: 
		| reads keycode and returns
		| ------------------------------------------------------
		| Input: 	NONE
		|
		| Output: 	keycode
		| ----------------------------------------------------*/

int KEYRead() {
  int i;
  if(!lcd_initialised)
    InitialiseLCD();  
  i = keystatus;
  keystatus = 0;
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return i;
}



