#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <forms.h>
#include <math.h>
#include <ctype.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>

#include "LCDDisp.h"
#include "protos.h"
#include "qcam.h"
#include "improc.h"
#include "eyesim.h"
#include "helpscreen.h"


/** make sure init code is only done once. */
int first_time = 1;
/** id of first robot thread. */
pthread_t first_id;
/** array of all robot ids. */
robot_id_type robot_id; 

pthread_mutex_t all_ready;
pthread_cond_t ready, pause_button;
pthread_attr_t thread_attr;

void main();
void ContinuousPause();

/** first_robot.
  this function determines whether this is the first robot started.
  returns 1 for first robot -- 0 else.
  also initialises multi-robot data.
  @author Braunl, 1998.
*/
  int first_robot() {
	if(first_time) {
		first_time = 0;
		first_id = pthread_self();
 
		/* assume single robot unless specified otherwise */
	        pthread_mutex_init(&sem, NULL);
	        pthread_mutex_init(&semview, NULL);
	}
	return pthread_equal(first_id, pthread_self());
}

/** FIndex.
  returns Index [0..MAX_ROBOTS-1] for current Thread.
  @author Minty, 1998.
*/
int FIndex(pthread_t ind) {
	int i;
	
	for(i=0; i < robot_id.Num_robot; i++) {
		if(robot_id.index[i] == ind)
			return i;		
	}
	fprintf(stderr,"ERROR: in FIndex %ld\n", ind);
        exit(0);
}

/** Init_Multi
  multi-robot data initialisations.
  @author Minty, 1998.
*/
int Init_Multi()
{
	int i,j;
	
	for(i = 0; i < MAX_ROBOTS; i++) {
		keystatus = 0;
		scrolling = 2;
		lcdline = 0;
		lcdpos = 0;
		distancePSD[i] = 1000;
		startPSD_ = 0;
		endPSD_ = 1000;
		IRrange = 50;
		/* lcd_initialised = FALSE; */
		vwCommand[i] = FALSE;
		stalled[i] = FALSE;
		vwInitiate[i] = FALSE;
		bumperAngle[i] = 0.0;
		hiddenVW[i] = 0;
		/* hiddenPSD[i] = 0; */
		AngleEst_[i] = 0.0;
		DistEst_[i] = 0.0;
	}

        for (i=1; i< MAX_ROBOTS; i++)  /* DUPLICATE FROM FIRST ROBOT */
        { for (j=0; j< MaxNumOfPSD;  j++)
          { 
PSD_Sensor[i][j] = PSD_Sensor[0][j];
            PSDSen[i][j].t   = PSDSen[0][j].t;
            PSDSen[i][j].a   = PSDSen[0][j].a;
            PSDSen[i][j].d   = PSDSen[0][j].d;
            PSDSen[i][j].semantic  = PSDSen[0][j].semantic;
          }

          for (j=0; j< MaxNumOfIR;   j++)
          { 
IR_Sensor[i][j] = IR_Sensor[0][j];
            IRSen[i][j].t   = IRSen[0][j].t;
            IRSen[i][j].a   = IRSen[0][j].a;
            IRSen[i][j].d   = IRSen[0][j].d;
            IRSen[i][j].semantic  = IRSen[0][j].semantic;
          }

          for (j=0; j< MaxNumOfBUMP; j++)
          { 
BUMP_Sensor[i][j] = BUMP_Sensor[0][j];
            BUMPSen[i][j].t   = BUMPSen[0][j].t;
            BUMPSen[i][j].a   = BUMPSen[0][j].a;
            BUMPSen[i][j].d   = BUMPSen[0][j].d;
            BUMPSen[i][j].semantic  = BUMPSen[0][j].semantic;
          }
          robotStartPos[i].radians = robotStartPos[0].radians;
          robotStartPos[i].x = robotStartPos[0].x;
          robotStartPos[i].y = robotStartPos[0].y;
        }
	return 1;
}

void ThreadFork()  {
  int i;

  for(i=0;i< robot_count; i++) {
    if(pthread_equal(robot_id.index[i], pthread_self()))
      return;
  }
  while((cState.map.w > (cState.w*cState.zoom)) || (cState.map.h > (cState.h*cState.zoom)))
      cState.zoom += 0.5; 
  cState.map.x = 0;
  cState.map.y = 0;

  if(first_robot()) {
    robot_count = 1;
    robot_id.index[0] = pthread_self();
    if(!fl_form_is_visible(view->viewscreen))  
      fl_show_form(view->viewscreen, FL_PLACE_FREE, FL_FULLBORDER, "View");

    pthread_mutex_init(&all_ready, NULL); /* init sema */
    pthread_cond_init(&ready, NULL); /* init cond */
    pthread_cond_init(&pause_button, NULL); /* init cond */
    pthread_attr_init(&thread_attr);
    pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
    pthread_attr_setschedpolicy(&thread_attr, SCHED_FIFO);
    //pthread_attr_setinheritsched(&thread_attr, PTHREAD_INHERIT_SCHED);
    pthread_mutex_lock(&all_ready);

    for(i=1; i < robot_id.Num_robot; i++)
      pthread_create(&(robot_id.r[i]), &thread_attr, (void *) &main, NULL);
    if (robot_count < robot_id.Num_robot)
      pthread_cond_wait(&ready, &all_ready);
    ContinuousPause();
    pthread_cond_broadcast(&pause_button);
    pthread_mutex_unlock(&all_ready);
  }
  else {  /* ALL OTHER ROBOTS 2..max */
    pthread_mutex_lock(&all_ready);
    robot_count++;
    robot_id.index[robot_count-1] = pthread_self();
    if(robot_count == robot_id.Num_robot)  {
      pthread_cond_broadcast(&ready);
    }
    pthread_cond_wait(&pause_button, &all_ready);
    pthread_mutex_unlock(&all_ready);
  }

}

