/*---------------------------------------------------------------------------
  |
  |     Filename: globalsim.h
  |
  |     Author: Nicholas Tay
  |
  |     Description: Header file containing list of all functions
  |
  L--------------------------------------------------------------------------
  */

#ifndef _protos_h
#define _protos_h

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "const.h"
#include "kern.h"
#include "vw.h"
#include "hdt.h"
#include "types.h"
#include "improc.h"
#include "multi.h"
#include "hdt_sem.h"

#ifndef PI
#define PI 3.141592654
#endif

typedef BYTE SIMimage[imagerows*imagecolumns*4];
typedef BYTE SIMcolimage[imagerows*imagecolumns*4][3];

#define MAXPOS 16
#define IMAGE_SIZE (160*120)

/* -------=< Constant for IR >=-----------*/
/* 
#define NumOfIR 7
#define IR_LR_Fangle 5     
#define IR_LR_Mangle 45
#define IR_LR_Bangle 90
#define IR_Backangle 180
*/
 
#define MaxNumOfIR 20
#define MaxNumOfPSD 20
#define MaxNumOfBUMP 20

#define NumOfObstacles 20

#define DefaultParamPath "/usr/lib/eyesim.p"

/* -------=< Global Variables >=---------- */

extern int keystatus, xDepth, scrolling, lcdline, lcdpos, imageSize, screen_num;
extern int colortable[64], distancePSD[MAX_ROBOTS], startPSD_, endPSD_;
extern int IRrange, IRlist[MaxNumOfIR], IRcount, sim_x, robot_count, TrailBuffer;
extern int OB_x[NumOfObstacles], OB_y[NumOfObstacles], OB_count, OB_rad;
extern BOOL **lcdpixel, lcd_initialised, vwCommand[MAX_ROBOTS], stalled[MAX_ROBOTS], vwInitiate[MAX_ROBOTS], initial[MAX_ROBOTS];
extern float bumperAngle[MAX_ROBOTS], AngleEst_[MAX_ROBOTS], DistEst_[MAX_ROBOTS];
extern char **text, *compareinput, *sText[MAX_ROBOTS], *IRinput[MAX_ROBOTS], *BUMPinput[MAX_ROBOTS], *PSDinput;
extern Display *disp;
extern XImage *ximage;
extern Window win;
extern XGCValues values;
extern Colormap cmap;
extern pthread_cond_t ready, pause_button;
extern GC gc;
extern BYTE ximagemem[IMAGE_SIZE*4];
extern struct timeb timePast[MAX_ROBOTS], stepTwo;
extern struct timeval checkOut, timeEstimate[MAX_ROBOTS];
extern SpeedType robotSpeed[MAX_ROBOTS];
extern VWHandle hiddenVW[MAX_ROBOTS];
extern PSDHandle hiddenPSD[MAX_ROBOTS];
extern PositionType robotView[MAX_ROBOTS];
extern float X_rob_[MAX_ROBOTS], Y_rob_[MAX_ROBOTS], err_rot, err_for, err_psd, err_ir;
extern char name[20];
extern SpeedType vwLimit;
extern int NumOfBUMP, NumOfIR, NumOfPSD, trail, counter[MAX_ROBOTS];
extern IRHandle IR_Sensor[MAX_ROBOTS][MaxNumOfIR];
extern BumpHandle BUMP_Sensor[MAX_ROBOTS][MaxNumOfBUMP];
extern int BUMP_detect[MAX_ROBOTS][MaxNumOfBUMP];
extern int IR_detect[MAX_ROBOTS][MaxNumOfIR];
extern int PSD_detect[MAX_ROBOTS][MaxNumOfIR];
extern PSDHandle PSD_Sensor[MAX_ROBOTS][MaxNumOfPSD];
extern SensorType BUMPSen[MAX_ROBOTS][MaxNumOfBUMP];
extern SensorType IRSen[MAX_ROBOTS][MaxNumOfIR];
extern SensorType PSDSen[MAX_ROBOTS][MaxNumOfPSD];
extern int mainthread;
extern struct sem sf;
extern int dbg;

extern robot_id_type robot_id;
extern int first_time;
extern pthread_t first_id;
extern pthread_attr_t thread_attr;
extern pthread_t pthread_self(void);
extern pthread_mutex_t sem, semview;
extern int robot_count;

/********* Miscellaneous functions - `global.c' *************/

extern int NewImage(int w, int h);
extern void DoText();
extern int printf(const char *, ...);
extern void (*RawToX)();
extern void CalcXferMode();
extern void InitialiseLCD();
extern void (*GetImage)(BYTE *);
extern void RawTo24BitX(BYTE *, int *);
extern void RawTo8BitX(BYTE *, BYTE *);
extern void xqc_createpalette(Colormap );

extern int first_robot();
extern int FIndex(pthread_t ind);
extern int Init();
extern void ThreadFork();

/********* Image processing functions - `improc.c' **********/

extern int IPLaplace (image *, image *);         
extern int IPSobel (image *, image *);         
extern int IPDither (image *, image *);           
extern int IPDiffer (image *, image *, image *);
extern int IPColor2Grey (colimage *, image *);   

/********* Key manipulation functions - `keysim.c' **********/

extern int KEYGetBuf (char *);                 
extern int KEYGet (void);                     
extern int KEYRead (void);                     
extern int KEYWait (int );               

/********* LCD display functions - `lcdsim.c' ***************/

extern int LCDClear( void );                      
extern int LCDPutChar (char );                    
extern int LCDSetChar ( int ,int ,char ); 
extern int LCDPutString ( char *);               
extern int LCDSetString ( int, int ,char *);    
extern int LCDMode ( int );                        
extern int LCDSetPos (int, int);            
extern int LCDPutGraphic ( image *);                
extern int LCDPutImage ( BYTE *);                
extern int LCDMenu (char *, char *, char *,char *);
extern int LCDMenuI (int , char *);
extern int LCDSetPixel (int,int,BOOL);             
extern int LCDInvertPixel (int, int);          
extern int LCDGetPixel (int, int);             
extern int LCDLine(int, int, int, int, int);
extern int LCDArea(int, int, int, int, int );

/********* Camera functions - `camsim.c' ********************/ 

extern int CAMInit ();                             
extern int CAMGetFrame ( image *);                  
extern int CAMGetColFrame ( colimage *);                    
extern int CAMSet (int ,int ,int );            
extern int CAMGet (int *,int *,int *);    
extern int CAMMode ( int );                                

/********* OS Functions - `OSmisc.c' *****************/

/*----------< UNIMPLEMENTED >--------------*/

extern int OSError(char *,int ,BOOL );
extern int OSMachineType(void);
unsigned char OSMachineID (void);
char * OSMachineName (void);
extern int OSEnable ( void );                  
extern int OSDisable ( void );                 
extern int OSGetVar(int);   
extern int OSPutVar(int, int);           

extern int OSMTInit(BYTE);              
extern struct tcb *OSSpawn(char *,int ,int ,int ,int );
extern int OSReady(struct tcb *);                        
extern int OSSuspend(struct tcb *);              
extern int OSReschedule();                             
extern int OSYield();                                  
extern int OSRun(struct tcb *);          
extern int OSGetUID(struct tcb *);                   
extern int OSKill(struct tcb *);         
extern int OSExit(int );        
extern int OSPanic(char *);        
extern int OSSleep(int );                     
extern int OSForbid();
extern int OSPermit();
  
/********* Semaphore Function - `OSmisc.c' ***************/

/*----------< UNIMPLEMENTED >--------------*/

extern int OSSemInit(struct sem *,int );
extern int OSSemP(struct sem *);       
extern int OSSemV(struct sem *);     

/*********** Timer Functions - `timer.c'  *****************/

extern int OSSetTime(int ,int ,int );     
extern int OSGetTime(int *,int *,int *,int *);
extern int OSShowTime(void);                 
extern int OSGetCount(void);
extern int OSWait (int);                        

/*
  extern TimerHandle OSAttachTimer(int scale, TimerFnc function);
  extern int OSDetachTimer(TimerHandle handle)
  */
/*
  extern int OSDownload(char *name,int *bytes,int baud,int handshake,int interface);    
  extern int OSInitRS232(int baud,int handshake,int interface);
  extern int OSSendRS232(char *chr,int interface);     
  extern int OSRecvRS232(char *buf,int interface);        
  extern int OSFlushInRS232(int interface);
  extern int OSFlushOutRS232(int interface);
  extern int OSCheckInRS232(int interface);
  extern int OSCheckOutRS232(int interface);
  */
/*
  extern int AUPlaySample(char* sample);   
  extern int AUCheckSample();            
  extern int AURecordSample(BYTE* buf, long len, long freq); 
  extern int AUCheckRecord();     */
extern int AUTone(int , int );        
extern int AUBeep();                         
extern int AUCaptureMic();
extern int AUCheckTone();                      
  
/********* PSD Functions - `psd_drive.c' *********/

extern PSDHandle PSDInit(DeviceSemantics);
extern int PSDRelease();
extern int PSDStart(PSDHandle, BOOL);      
extern int PSDStop();
extern BOOL PSDCheck();
extern int PSDGet(PSDHandle);
extern int PSDGetRaw(PSDHandle);

/*
  extern ServoHandle SERVOInit(DeviceSemantics semantics);
  extern int SERVORelease (ServoHandle handle)
  extern int SERVOSet (ServoHandle handle,int angle);
  */
/*
  extern MotorHandle MOTORInit(DeviceSemantics semantics);
  extern int MOTORRelease (MotorHandle handle)
  extern int MOTORDrive (MotorHandle handle,int speed);
  */
/*
  extern QuadHandle QuadInit(DeviceSemantics semantics);
  extern int QuadRelease(QuadHandle handle);
  extern int QuadReset(QuadHandle handle);
  extern int QuadRead(QuadHandle handle);
  extern DeviceSemantics QUADGetMotor(DeviceSemantics semantics);
  extern float QUADODORead(QuadHandle handle);
  extern int QUADODOReset(QuadHandle handle);
  */

/********* VW functions - `vw.c' **********/
extern VWHandle VWInit(DeviceSemantics, int);
extern int VWRelease(VWHandle);
extern int VWSetSpeed(VWHandle, meterPerSec, radPerSec);
extern int VWGetSpeed(VWHandle, SpeedType*);
extern int VWSetPosition(VWHandle, meter, meter, radians);
extern int VWGetPosition(VWHandle, PositionType*);
extern int VWStartControl(VWHandle, float, float, float, float);
extern int VWStopControl(VWHandle);
extern int VWGetPosition(VWHandle, PositionType *);
extern int VWDriveStraight(VWHandle, meter, meterPerSec);
extern int VWDriveTurn(VWHandle handle, radians, radPerSec);
extern int VWDriveCurve(VWHandle, meter, radians, meterPerSec);
extern float VWDriveRemain(VWHandle);
extern int VWDriveDone(VWHandle);
extern int VWDriveWait(VWHandle);

/********* Bumper functions - `bump.c' ************/

extern BumpHandle BUMPInit(DeviceSemantics);
extern int BUMPRelease(BumpHandle);
extern int BUMPCheck(BumpHandle , int *);
  
/********* Infra Red functions - `ir.c' ***********/

extern IRHandle IRInit(DeviceSemantics);
extern int IRRelease(IRHandle);
extern int IRRead(IRHandle);
  
/*
  extern BYTE OSReadInLatch(int latchnr);
  extern BYTE OSWriteOutLatch(int latchnr, BYTE mask, BYTE value);
  extern BYTE OSReadOutLatch(int latchnr);
  extern BYTE OSReadParData();
  extern void OSWriteParData(BYTE value);
  extern BYTE OSReadParSR();
  extern void OSWriteParCTRL(BYTE value);
  extern BYTE OSReadParCTRL();
  */

  extern int OSGetAD(int);
/*  extern int OSOffAD(int mode);
  */

#endif
