/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/* Functions:                                                        */
/* int PSD_Setup(int semantics, void* dataarea); | init single PSD   */
/* int PSD_Start(int bitmask, BOOL cycle);       | shoot PSD(s)      */
/* int PSD_Check();                              | check if shot done*/
/* int PSD_Stop();                               | stop cyclic       */
/* int PSD_Release();                            | release ALL PSDs  */
/* int PSD_Get(int handle);                      | get act. distance */
/* int PSD_GetRaw(int handle);                   | get act. raw_value*/
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <forms.h>
#include <sys/timeb.h>
#include "viewscreen.h"
#include "protos.h"
// #include "multi.h"
  
/* PSDHandle hiddenPSD[MAX_ROBOTS]; */
int distancePSD[MAX_ROBOTS];
int lastPSD;
int startPSD_, endPSD_;
BOOL cyclePSD;
BOOL isStarted=FALSE;
struct timeb cntTime, lastTime;
int PSDcount = 0;

PSDHandle PSDInit(DeviceSemantics semantics)  {
  int i, j=0;
  int PSDsem = -semantics+PSD;
  if(!lcd_initialised)  
    InitialiseLCD();
  if(robot_count != robot_id.Num_robot)
      ThreadFork();

  while ((PSDsem >= 0) && (j < NumOfPSD))  {
    if ((PSD_Sensor[FIndex(pthread_self())][j] == 0) && (semantics == PSDSen[FIndex(pthread_self())][j].semantic))  {

      PSD_Sensor[FIndex(pthread_self())][j] = rand()%10 + 201 + 10*PSDsem;
      PSDcount++;
      pthread_mutex_lock(&sem);
      //fl_winset(FL_ObjWin(view->screenText));
      //fl_rectf(view->screenText->x+1,view->screenText->y+1,view->screenText->w-2,view->screenText->h-2,FL_COL1);
      pthread_mutex_unlock(&sem);
        strcpy(PSDinput,"PSD (");
        for(i=0;i<NumOfPSD;i++)  
          if(PSD_Sensor[0][i]) {
            strcat(PSDinput," ");
            strcat(PSDinput, PSDSen[0][i].name); 
          }
        strcat(PSDinput," )");
      DoText();
      return PSD_Sensor[FIndex(pthread_self())][j];
    } 
    j++;
  }
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int PSDRelease() {
  int i;
  /*
  if(hiddenPSD[FIndex(pthread_self())] == 0)  {
    fprintf(stderr,"NO PSD initialised\n");
    return -1;
  }
  hiddenPSD[FIndex(pthread_self())] = 0;
  return 0; */

  for(i=0; i<NumOfPSD; i++) 
    if(PSD_Sensor[FIndex(pthread_self())][i]) {
      PSD_Sensor[FIndex(pthread_self())][i] = 0;
      PSDcount--;
    }
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int PSDStart(PSDHandle bitmask, BOOL cycle) {
  int i;
  BOOL sim_working = FALSE;
  /*
  ftime(&cntTime);
  if(hiddenPSD[FIndex(pthread_self())] == 0) {
    fprintf(stderr, "NO PSD initialised\n");
    return -1;
  }
  cyclePSD = cycle;
  lastTime = cntTime;
  isStarted=TRUE;
  return 0;
  */

  for(i=0; i<NumOfPSD; i++)
    if(PSD_Sensor[FIndex(pthread_self())][i]!=0) 
      sim_working = TRUE;
    if (!sim_working) {
      fprintf(stderr,"NO PSD initialised\n");
      return -1;
    }
  cyclePSD = cycle;
  lastTime = cntTime;
  isStarted=TRUE;
  return 0;
}

int PSDStop() {
  isStarted = FALSE;
  return 0;
}

BOOL PSDCheck() {
  int i;
  /*
  if(hiddenPSD[FIndex(pthread_self())] == 0) {
    fprintf(stderr, "NO PSD initialised\n");
    return -1;
  } */
  for(i=0; i<NumOfPSD; i++)
    if(PSD_Sensor[FIndex(pthread_self())][i]==0) {
      fprintf(stderr,"NO PSD initialised\n");
      return -1;
    }
  if(!isStarted) {
    fprintf(stderr, "NO PSD measuring started\n");
    return -1;
  }
  return TRUE;
}


int PSDGet(PSDHandle handle) {
  int i = 0;
  
  if (handle == 0) {
    fprintf(stderr,"PSD not initialised %ld \n",pthread_self());
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return -1;
  }
  while((i<NumOfPSD) && (handle != PSD_Sensor[FIndex(pthread_self())][i]))
    i++;
  if(i == NumOfPSD) {
    fprintf(stderr,"PSD not found %d - %ld\n", handle, pthread_self());
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    return -1;
  }
  if(!isStarted) {
    fprintf(stderr, "NO PSD measuring started\n");
    return -1;
  }
  ftime(&cntTime);
  if(cyclePSD) {
    lastPSD = PSD_detect[FIndex(pthread_self())][i];
    if(lastPSD < 0)
      lastPSD = 0;
    else if(lastPSD>=1000)
      lastPSD = 999;
    lastTime = cntTime;
  } else {
    if((cntTime.time - lastTime.time) > 0) {
      lastPSD = PSD_detect[FIndex(pthread_self())][i];
      lastTime = cntTime;
    } else if((cntTime.millitm - lastTime.millitm) > 60) {
      lastPSD = PSD_detect[FIndex(pthread_self())][i];
      lastTime = cntTime;
    }
  }
  pthread_mutex_lock(&sem);
  fl_redraw_object(view->screen);
  fl_check_forms();
  pthread_mutex_unlock(&sem);
  return lastPSD;
}

int PSDGetRaw(PSDHandle handle) {
  return PSDGet(handle); 
  
}

