/*
| ---------------------------------------------------------------------------------
| Filename: timer.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (k_schmit@informatik.uni-kl.de)
| Description: 
| timer routines
---------------------------------------------------------------------------------
| Functions:
| int OSSetTime(int,int,int);                   | set time
| int OSGetTime(int *,int *,int *,int *);       | read time
| int OSShowTime(void);                         | display time
| int OSGetCount(void);                         | get system counter value
|
---------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/timeb.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include <forms.h>
#include "protos.h"
#include "eyesim.h"
// #include "multi.h"
 
time_t timeInit = 0;
struct timeb timePast[MAX_ROBOTS];

/*-------------------------------------------------------------------- */

/* Clock Routines */
/* -------------- */

/* return system counter value */
int OSGetCount()
{
  struct timeb nowtime;
  ftime(&nowtime);
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return ((nowtime.time-timePast[FIndex(pthread_self())].time)*100 + (nowtime.millitm-timePast[FIndex(pthread_self())].millitm)/10);
}

/* set_time - Set the real time clock to a specific time. */
int OSSetTime(int hrs,int mins,int secs)
{
    struct tm timeBroke;

    timeBroke.tm_sec = secs;
    timeBroke.tm_min = mins;
    timeBroke.tm_hour = hrs;
    timeBroke.tm_mday = 1;
    timeBroke.tm_mon = 1;
    timeBroke.tm_year = 1970;
    timeBroke.tm_wday = 1;
    timeBroke.tm_yday = 1;
    timeInit = mktime(&timeBroke);
    ftime(&timePast[FIndex(pthread_self())]);
    OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
    OSSemV(&sf);
    return 0;
}

/* get_time - Returns timer values. */
int OSGetTime(int *hrs,int *mins,int *secs,int *ticks)
{
  struct timeb nowtime;
  struct tm *timeBroke;
  time_t timeCalc;

  ftime(&nowtime);
  timeCalc = timeInit + (nowtime.time - timePast[FIndex(pthread_self())].time);
  timeBroke = (gmtime(&timeCalc));
  *hrs = timeBroke->tm_hour;
  *mins = timeBroke->tm_min;
  *secs = timeBroke->tm_sec;
  *ticks = (unsigned short)((nowtime.millitm - timePast[FIndex(pthread_self())].millitm) /10); 
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int OSShowTime()
{
  struct timeb nowtime;
  char timePrint[20];
  time_t timeCalc;

  ftime(&nowtime);
  timeCalc = timeInit + (nowtime.time - timePast[FIndex(pthread_self())].time);
  strncpy(timePrint,ctime(&timeCalc),20);
  printf("%s",timePrint+10);
  OSSemP(&sf);
  pthread_mutex_lock(&sem);
  fl_check_forms();
  fl_redraw_object(view->screen);
  pthread_mutex_unlock(&sem);
  OSSemV(&sf);
  return 0;
}

int OSWait(int n)  {
  struct timeval t, waitSec, nowtime;
  struct timezone z;

  gettimeofday(&t,&z);
  waitSec.tv_sec = n / 100 + t.tv_sec;
  waitSec.tv_usec = (n *10000) + t.tv_usec; 
  if(waitSec.tv_usec >= 1000000)  {
    waitSec.tv_sec++;
    waitSec.tv_usec = waitSec.tv_usec % 1000000;
  }
  do {
    gettimeofday(&nowtime,&z);
   
   // OSSemP(&sf);
    pthread_mutex_lock(&sem);
    fl_check_forms();
    fl_redraw_object(view->screen);
    pthread_mutex_unlock(&sem);
   // OSSemV(&sf);
  } while((nowtime.tv_sec<=(waitSec.tv_sec+1)) && ((nowtime.tv_sec<waitSec.tv_sec)||(nowtime.tv_usec<waitSec.tv_usec)));
  // || (nowtime.millitm < waitMilli))  {
  return 0;
}
