#ifndef  TYPES_H
#define  TYPES_H

/* 4 WORD variables can be stored into tpu ram to survive reset */
#define SAVEVAR1    0           /* for word saving */
#define SAVEVAR2    4
#define SAVEVAR3    8
#define SAVEVAR4    12

#define SAVEVAR1a       20       /* for byte saving */
#define SAVEVAR1b       21
#define SAVEVAR2a       24
#define SAVEVAR2b       25
#define SAVEVAR3a       28
#define SAVEVAR3b       29
#define SAVEVAR4a       32
#define SAVEVAR4b       33

/* USRResident operation codes */
#define GET     0
#define SET     1


/* image is 80x60 but has a border of 1 pixel */
#define imagecolumns 82
#define imagerows 62

#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif

#if !defined(_BOOL)
#define _BOOL
typedef unsigned char BOOL;
#define TRUE    1
#define FALSE   0
#define PERHAPS 2
#endif

typedef BYTE image[imagerows][imagecolumns];
typedef BYTE colimage[imagerows][imagecolumns][3];

/* tone datatype */
typedef struct{
	int freq;
	int len;
	}tone;
	
/* USER-IRQ datatypes */
typedef int TimerHandle;
typedef void (*TimerFnc)(void);

/* RADIO communication */
enum {
  MAXEYE    = 16, /* max no. of EyeBots in communication          */
  MSGMAXLEN = 35, /* max no. of payload bytes per message */

  /* Addresses */
  BROADCAST = 127
};

#endif

