/*
 * xsim.c
 *
 * Elliot Nicholls <nicho-ej@ee.uwa.edu.au>
  Edited Nicholas Tay.....
 *
 * Map section of the eyebot simulator
 **********************************************************************/

/* 	$Id: xsim.c,v 1.2 1999/11/13 14:24:49 pere Exp $	 */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <forms.h>
#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <signal.h>

#include "viewscreen.h"
#include "eyesim.h"
#include "protos.h"
#include "LCDDisp.h"
#include "helpscreen.h"
#include "errorChange.h"
// #include "multi.h"
 
#define NO_MOVE		0
#define IS_MOVE_ROBOT	1
#define IS_ROTATE_ROBOT	2
#define IS_MOVE_MAP	3
#define IS_RESIZE_MAP   4
#define DELETE_ROBOT	5
#define MAX_BUFFER	20000

Display *disp;
char *IRinput[MAX_ROBOTS], *PSDinput, *BUMPinput[MAX_ROBOTS], *sText[MAX_ROBOTS];
static GC gcFree;
int displayScreen, sim_x, sim_y, sim_w = 1000, sim_h = 1000, OB_rad = 27;
int IsInit = 0, OB_x[NumOfObstacles], OB_y[NumOfObstacles], OB_count = 0;
float X_rob_[MAX_ROBOTS], Y_rob_[MAX_ROBOTS], sim_z = 5.0, err_psd = 0, err_ir = 0, err_rot = 0, err_for = 0;
int count = 0, temp_mx, temp_my;
FD_viewscreen *view;
FD_helpscreen *help;
FD_paramChange *errchange;
XPoint *data[MAX_ROBOTS];
int counter[MAX_ROBOTS], trail = 1;
struct timeval timeEstimate[MAX_ROBOTS], firstIn, checkOut;
struct timeb stepOne, stepTwo;
struct sem sf; 
int robi = 0;

char name[20], *dText;
SpeedType vwLimit;
int NumOfIR, NumOfPSD, NumOfBUMP, TrailBuffer = 10000;
IRHandle IR_Sensor[MAX_ROBOTS][MaxNumOfIR];
PSDHandle PSD_Sensor[MAX_ROBOTS][MaxNumOfPSD];
SensorType IRSen[MAX_ROBOTS][MaxNumOfIR], BUMPSen[MAX_ROBOTS][MaxNumOfBUMP], PSDSen[MAX_ROBOTS][MaxNumOfPSD];
int IR_detect[MAX_ROBOTS][MaxNumOfIR];
int PSD_detect[MAX_ROBOTS][MaxNumOfPSD];
BOOL initial[MAX_ROBOTS] = {0};
State cState;
Robot robot[MAX_ROBOTS];
void Init_Free(Window viewscreen);
void DrawRobot(Window viewscreen, BOOL sim_blue);
void DrawMap(Window viewscreen,BOOL sim_map);
void DrawObs(Window viewscreen,BOOL sim_blue);
int ShutdownSim(FL_OBJECT *ob, Window win, int w, int h, XEvent *ev, void *d);
int ViewscreenHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key, void *xev);
float SIMsqr(float x);
void CalcPosition();
BOOL DrawPartial(int, int);
BOOL GetXAngles(int, int, int *, int *); 
BOOL GetYAngles(int, int, int *, int *); 
void GetSensorData();
int Init_Multi();

void InitialiseLCD() {
  int i;
  char *fakeargv[2];
  FILE *fp;

  //if(first_robot()) {
    robot[0].radians = 0;
    robot[0].x = 200;
    robot[0].y = 200;
    robotStartPos[0].x = 0;
    robotStartPos[0].y = 0;
    robotStartPos[0].radians = 0;
  lcd_initialised = TRUE;
    robot_count = 0;
    text = (char **)calloc(7,sizeof(char *));
    compareinput = (char *)calloc(100,sizeof(char));
    fakeargv[0] = (char *)calloc(10,sizeof(char));
    fakeargv[1] = (char *)calloc(10,sizeof(char));
    IRinput[0] = (char *)calloc(50,sizeof(char));
    PSDinput = (char *)calloc(50,sizeof(char));
    BUMPinput[0] = (char *)calloc(50,sizeof(char));
    sText[0] = (char *)calloc(150,sizeof(char));
    dText = (char *)calloc(200,sizeof(char));
    strcpy(fakeargv[0],"Eyebot");
    strcpy(fakeargv[1],"Sim");
    lcdpixel = (BOOL **)calloc(64,sizeof(BOOL *));
    for (i=0;i<MAX_ROBOTS;i++) {
      counter[i] = 0;
      data[i] = (XPoint *)calloc(MAX_BUFFER,sizeof(XPoint));
    }
    for(i=0;i<7;i++) {
      text[i] = (char *)calloc(40, sizeof(char));
      strcpy(text[i],"\n");
    }
    for(i=0;i<64;i++)
      lcdpixel[i] = (BOOL *)calloc(128,sizeof(BOOL));
    ftime(&timePast[0]);
    stepTwo = timePast[0];
    i=2;
    //pthread_mutex_lock(&sem);
    disp = fl_initialize(&i, fakeargv, 0, 0, 0);
    view = create_form_viewscreen();
    fd_eyebot = create_form_EyeBotLCD();
    help = create_form_helpscreen();
    errchange = create_form_paramChange();
    //pthread_mutex_lock(&sem);
    fl_set_form_geometry(fd_eyebot->EyeBotLCD,50,50,310,320);
    fl_show_form(fd_eyebot->EyeBotLCD,FL_PLACE_GEOMETRY,FL_FULLBORDER,"EyeBotLCD");
    fl_set_form_geometry(view->viewscreen,380,50,495,520);
    fl_set_form_minsize(view->viewscreen,495,520);
    //pthread_mutex_unlock(&sem);
    //fl_show_form(view->viewscreen, FL_PLACE_FREE, FL_FULLBORDER, "View");

    //pthread_mutex_unlock(&sem);
    cState.x = view->screen->x;
    cState.y = view->screen->y;
    cState.h = view->screen->h;
    cState.w = view->screen->w;
    cState.map.x = sim_x = 0;
    cState.map.y = sim_y = 0;
    cState.map.h = 5000;
    cState.map.w = 5000;
    X_rob_[0] = 200;
    Y_rob_[0] = 200;
    cState.zoom = 5.0;
    displayScreen = DefaultScreen(disp);
    OSSemInit(&sf,1);
    robot_id.Num_robot = 1; 
    robot_id.index[0] = pthread_self();
    if ((fp = fopen("eyesim.p","r")) != NULL) {
      fclose(fp);
      Param("eyesim.p");
    } else if ((fp = fopen(getenv("EYESIM_HOME"),"r")) != NULL) {
      fclose(fp);
      Param(getenv("EYESIM_HOME"));
    } else if ((fp = fopen(DefaultParamPath,"r")) != NULL) {
      fclose(fp);
      Param(DefaultParamPath);
    } 
    Init_Multi();
    //pthread_mutex_lock(&sem);
    fl_check_forms();
    //pthread_mutex_unlock(&sem);
}

void Init_Free(Window viewscreen) {

  
  gcFree = XCreateGC(disp, viewscreen, 0, 0);
  robot[0].radians = 0;
  robotStartPos->x = 0;
  robotStartPos->y = 0;
  robotStartPos->radians = 0;
  DoText();
  XMapWindow(disp, viewscreen);
  XFlush(disp);

  return;
}
void DrawObs(Window viewscreen, BOOL sim_blue) {

  XColor color, dummy;
  int xpos, ypos, i;

  for(i=0; i < OB_count; i++) {
    xpos = (int)(((float)(OB_x[i]-cState.map.x)/cState.zoom)+cState.x) -
  	   (int)((float)OB_rad/cState.zoom);
    ypos = (int)(((float)(OB_y[i]-cState.map.y)/cState.zoom)+cState.y) -
	   (int)((float)OB_rad/cState.zoom);
    XAllocNamedColor(disp, DefaultColormap(disp, displayScreen), "red", &color,
&dummy);
    if(sim_blue)
      XSetForeground(disp, gcFree, fl_get_pixel(FL_ORCHID));
    else
      XSetForeground(disp, gcFree, fl_get_pixel(FL_WHITE));
    XFillArc(disp, viewscreen, gcFree, xpos, ypos, OB_rad*2/cState.zoom, OB_rad*2/cState.zoom, 90*64, 360*64);
  }
}

void DrawRobot(Window viewscreen, BOOL sim_blue) {

  XColor color, dummy;
  int xDiff, yDiff, xCorner, yCorner,xpos, ypos, i;
  int length = (ROBOT_RADIUS + 2*ROBOT_RADIUS*ROBOT_PSCALE);

 for(i=0; i < robot_id.Num_robot; i++) { 
  if(robot_id.index[i] != -1)  {

  robot[i].x = X_rob_[i];
  robot[i].y = Y_rob_[i];

  xpos = (int)(((float)(robot[i].x-cState.map.x)/cState.zoom)+cState.x);
  ypos = (int)(((float)(robot[i].y-cState.map.y)/cState.zoom)+cState.y);

  /* convert x,y coordinates to center of circle */
  xCorner = xpos - (int)((float)ROBOT_RADIUS/cState.zoom);
  yCorner = ypos - (int)((float)ROBOT_RADIUS/cState.zoom);

  /* work out differences for drawing line */
  xDiff = (int)((float)length * cos(robot[i].radians) /(float)cState.zoom);
  yDiff = -(int)((float)length * sin(robot[i].radians) / (float)cState.zoom); /* negative as X coordinate system is reversed! */

  // pthread_mutex_lock(&sem);
  XAllocNamedColor(disp, DefaultColormap(disp, displayScreen), "red", &color,
&dummy);      
  if((trail) && (sim_blue)) {
    XSetForeground(disp, gcFree, fl_get_pixel(FL_RED));
    XDrawPoints(disp, viewscreen, gcFree, data[i], counter[i], CoordModeOrigin);
  }

  if (sim_blue)
    if (i==0) /* FIRST robot */
          XSetForeground(disp, gcFree, fl_get_pixel(FL_BLUE));
     else XSetForeground(disp, gcFree, fl_get_pixel(FL_GREEN));
  else
    XSetForeground(disp, gcFree, fl_get_pixel(FL_WHITE));
  // pthread_mutex_unlock(&sem);

    if((xpos + xDiff) > (cState.x+cState.w))  {
      yDiff = fabs((xpos-cState.x-cState.w)/(float)(xDiff))*yDiff;
      xDiff = cState.x+cState.w-xpos;
    } else if ((xpos+xDiff) < cState.x)  {
      yDiff = yDiff*fabs((xpos-cState.x)/(float)(xDiff));
      xDiff = cState.x - xpos; 
    }
    if((ypos + yDiff) > (cState.y+cState.h))  {
      xDiff = fabs((ypos-cState.y-cState.h)/(float)(yDiff))*xDiff;
      yDiff = cState.y+cState.h - ypos;
    } else if ((ypos+yDiff) < cState.y)  {
      xDiff = xDiff*fabs((ypos-cState.y)/(float)(yDiff));
      yDiff = cState.y - ypos;
    }
  if(DrawPartial(xpos, ypos)) {
  } else {
    if((ROBOT_RADIUS*2/cState.zoom) <cState.h) 
        XDrawArc(disp, viewscreen, gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, 90*64, 360*64);
  }
  XDrawLine(disp, viewscreen, gcFree, xpos , ypos , xpos + xDiff, ypos + yDiff);
 
 }
 }
  XFlush(disp);
  return;
  
}

void CalcPosition()  {
  int i, j;
  float timediff = 0, my_ang_;
  struct timezone z;

  ftime(&stepOne);
  gettimeofday(&firstIn,&z);
  if(!dontMove)
   for(i=0; i < robot_id.Num_robot; i++) {
     if(hiddenVW[i] && (!stalled[i])) {
      timediff = (firstIn.tv_sec - checkOut.tv_sec)*1000.00+(firstIn.tv_usec-checkOut.tv_usec)/1000.0000;
      if(!vwInitiate[i])  
        robot[i].radians += (float)(rand() % 100-50)/10000*err_rot;
    X_rob_[i] += ((1.0+(float)((rand()%100)-50)/100.0*err_for)*robotSpeed[i].v*timediff * cos(robot[i].radians));
    Y_rob_[i] -= ((1.0+(float)((rand()%100)-50)/100.0*err_for)*robotSpeed[i].v*timediff * sin(robot[i].radians));
    robot[i].radians = robot[i].radians + (1.0+err_rot)*robotSpeed[i].w*timediff/1000.0;

    if((AngleEst_[i] != 0.0000) || (DistEst_[i] != 0.0000))  {
      if(AngleEst_[i] != 0.0000)  {
        AngleEst_[i] -= fabs(timediff*robotSpeed[i].w/1000.0);
 	if(AngleEst_[i] <= 0.0000)  {
	  robot[i].radians += AngleEst_[i]*robotSpeed[i].w/fabs(robotSpeed[i].w);
	  AngleEst_[i] = 0.00;
	  robotSpeed[i].w = 0.000000;
	}
      } 
      if(DistEst_[i] != 0.0000)  {
	DistEst_[i] -= fabs(((timediff))/1000.0000*robotSpeed[i].v);
     	if(DistEst_[i] <= 0.0000) {
          X_rob_[i] += 1000.0000*DistEst_[i] * cos(robot[i].radians);
          Y_rob_[i] -= 1000.0000*DistEst_[i] * sin(robot[i].radians);
	  DistEst_[i] = 0.00;
	  robotSpeed[i].v = 0.000000;
	}
      }
    }
    robot[i].x = X_rob_[i];
    robot[i].y = Y_rob_[i];
    if(robot[i].radians > (2*PI))
      robot[i].radians -= 2*PI;

    if((robot[i].x>(cState.map.x+cState.w*cState.zoom-ROBOT_RADIUS
      ))||(robot[i].x < (cState.map.x+ROBOT_RADIUS)))
      cState.map.x = robot[i].x - cState.w/2*cState.zoom;
    if((robot[i].y>(cState.map.y+cState.h*cState.zoom-ROBOT_RADIUS
      ))||(robot[i].y < (cState.map.y+ROBOT_RADIUS)))
      cState.map.y = robot[i].y - cState.h/2*cState.zoom;
  
    if(trail)
    if(counter[i] < TrailBuffer)  {
      data[i][counter[i]].x = (int)(((float)(X_rob_[i]-cState.map.x)/cState.zoom)+cState.x);
      data[i][counter[i]].y = (int)(((float)(Y_rob_[i]-cState.map.y)/cState.zoom)+cState.y);
      counter[i]++;
    } else {
      for(j=0;j<TrailBuffer - 1;j++)  {
        data[i][j].x = data[i][j+1].x;
        data[i][j].y = data[i][j+1].y;
      }
      data[i][TrailBuffer-1].x = (int)(((float)(X_rob_[i]-cState.map.x)/cState.zoom)+cState.x);
      data[i][TrailBuffer-1].y = (int)(((float)(Y_rob_[i]-cState.map.y)/cState.zoom)+cState.y);
    }
  }
 } /* end of for */
  for(i=0;i<robot_count;i++)
    for(j=0;j<OB_count;j++)  {
      if(((robot[i].x - OB_x[j])*(robot[i].x - OB_x[j])
          + (robot[i].y - OB_y[j])*(robot[i].y - OB_y[j])) <
          (ROBOT_RADIUS + OB_rad)*(ROBOT_RADIUS + OB_rad)) {
        if((OB_x[j] - robot[i].x) == 0)
          if(OB_y[j] < robot[i].y)
            my_ang_ = PI / 2;
          else
            my_ang_ = -PI / 2;
        else {
          my_ang_ = atan((robot[i].y - OB_y[j]) / abs(OB_x[j] - robot[i].x));
          if(OB_x[j] < robot[i].x)
            my_ang_ = PI - my_ang_;
        }
        OB_x[j] += cos(my_ang_) * robotSpeed[i].v * cos(my_ang_ -
                robot[i].radians) * timediff;
        OB_y[j] -= sin(my_ang_) * robotSpeed[i].v * cos(my_ang_ -
                robot[i].radians) * timediff;
      }
    }

  checkOut.tv_sec = firstIn.tv_sec;
  checkOut.tv_usec = firstIn.tv_usec;
}


BOOL GetXAngles(int x, int linex, int *start, int *finish) {
  if(abs(x-linex) >= (ROBOT_RADIUS/cState.zoom))
    return FALSE;
  else {
    if(linex < ((cState.w+cState.x)/2) )  {
      *finish = (int)(180/PI *acos((double)(linex-x)*cState.zoom/ROBOT_RADIUS));
      *start = 360 - (*finish);
    } else {
      *start = (int)(180/PI *acos((double)(linex-x)*cState.zoom/ROBOT_RADIUS));
      *finish = 360 - (*start);
    }
    if(*finish == *start)
      *finish += 360;
    return TRUE;
  } 
}

BOOL GetYAngles(int y, int liney, int *start, int *finish)  {
  if(abs(y-liney) >= (ROBOT_RADIUS/cState.zoom))
    return FALSE;
  else {
    if(liney < ((cState.h+cState.y)/2) )  {
      *start = 90 + (int)(180/PI *acos((double)(y-liney)*cState.zoom/ROBOT_RADIUS));
      *finish = (540 - *start) % 360;
    } else {
      *finish = 90 + (int)(180/PI *acos((double)(y-liney)*cState.zoom/ROBOT_RADIUS));
      *start = (540 - *finish) % 360;
    }
    if(*finish == *start)
      *finish += 360;
    return TRUE;
  } 
}

BOOL DrawPartial(int xpos, int ypos)  {
  int s1, s2, f1, f2,xCorner, yCorner;
  BOOL isX = FALSE, isY = FALSE;

  yCorner = ypos - ROBOT_RADIUS/cState.zoom;
  xCorner = xpos - ROBOT_RADIUS/cState.zoom;
  if ((isX = GetXAngles(xpos, cState.x, &s1, &f1)) == 0)
    isX = GetXAngles(xpos,cState.w+cState.x,&s1, &f1);
  if((isY = GetYAngles(ypos, cState.y, &s2, &f2))  == 0)
    isY = GetYAngles(ypos, cState.y+cState.h, &s2, &f2);
  if(isY && isX)  {
    if((s2 < s1) || (((90 - s1) > 0) && ((s2 - 270) > 0)))  {
      XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s1*64, ((f2 - s1 + 360) % 360)*64);
      if(((f2 - s1 +360)%360) > 180)
        XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s2*64, ((f1 - s2 + 360) % 360)*64);

    } else if((s1 < s2) && !(((90 - s1) >0) && ((s2 - 270) > 0)))  {
      XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s2*64, ((f1 - s2 + 360) % 360)*64);
      if(((f1 - s2 + 360)%360) > 180)
        XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s1*64, ((f2 - s1 + 360) % 360)*64);
    }
  } else if (isY)  
    XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s2*64, ((f2-s2+360)%360)*64);
  else if (isX)  
    XDrawArc(disp, FL_ObjWin(view->screen), gcFree, xCorner, yCorner, ROBOT_RADIUS*2/cState.zoom, ROBOT_RADIUS*2/cState.zoom, s1*64, ((f1-s1+ 360)%360)*64);
  return (isX || isY);

}
      


void DrawMap(Window viewscreen, BOOL sim_map) {

  XSegment *map;
  int numSeg;
  
  //pthread_mutex_lock(&sem);
  XSetForeground(disp, gcFree, fl_get_pixel(FL_BLACK));
  //pthread_mutex_unlock(&sem);
  map = Filter(&numSeg);
  if((numSeg > 0) && sim_map) {
    //pthread_mutex_lock(&sem);
    XDrawSegments(disp, viewscreen, gcFree, map, numSeg);
    //pthread_mutex_unlock(&sem);
    free(map);
  }
  
}


int ShutdownSim(FL_OBJECT *ob, Window win, int w, int h, XEvent *ev, void *d) {
  exit(0);
  return 1;
}

void GetSensorData()  {
  int i;
  float diffl, diffr, diffx, diffy;
  PositionType ppos;
  char added[10];

  fl_set_object_lcol(view->errorText,FL_COL1);
  fl_set_object_lcol(view->dataText,FL_COL1);
  fl_set_object_label(view->dataText," ");
  fl_set_object_lcol(view->dataText,FL_BLACK);
  dText[0] = '\0';
  diffx = robot[0].x - robotStartPos[0].x;
  diffy = robot[0].y - robotStartPos[0].y;
  diffl = sqrt(diffx * diffx + diffy * diffy);
  if(diffx == 0)
    if(diffy >= 0)
      diffr = PI/2;
    else
      diffr = -PI/2;
  else {
    diffr = atan(diffy / abs(diffx));
    if (diffx < 0)
      diffr = PI - diffr;
  }
  ppos.phi = robot[0].radians + robotStartPos[0].radians;
  while (ppos.phi > PI)
    ppos.phi -= 2*PI;
  while (ppos.phi < -PI)
    ppos.phi += 2*PI;
  ppos.x   = (float)((float)diffl * cos(diffr - robotStartPos[0].radians)) / 1000.0;
  ppos.y   = -(float)((float)diffl * sin(diffr -
        robotStartPos[0].radians)) / 1000.0;

  sprintf(added,"%.2f  %.2f  %.2f\n",ppos.x, ppos.y, ppos.phi);
  strcat(dText,added);
  for(i=0;i<NumOfPSD;i++)
    if(PSD_Sensor[0][i] != 0)  {
      sprintf(added,"%4d   ",PSD_detect[0][i]);
      strcat(dText,added);
    }
  strcat(dText,"\n");
  for (i=0;i<NumOfIR;i++)  
    if(IR_Sensor[0][i] != 0)  {
      sprintf(added,"%1d   ",IR_detect[0][i]);
      strcat(dText,added);
    }
  strcat(dText,"\n");
  //pthread_mutex_lock(&sem);
  if(stalled[0])
    fl_set_object_lcol(view->errorText,FL_RED);
  //strcat(dText,"Robot has hit obstacle!!");
  fl_set_object_label(view->dataText,dText);
  fl_set_object_label(view->screenText,sText[0]);
  //pthread_mutex_unlock(&sem);

}

int ViewscreenHandler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my, int key, void *xev) {

  int mxDiff, myDiff, edge;
  float nowRatio, beforeRatio;

  // pthread_mutex_lock(&semview);
  obj->wantkey = FL_KEY_ALL;
  obj->input = 1;
  switch(event) {
  case FL_DRAW:
    fl_redraw_object(fd_eyebot->TEXTSPACE);
    if(IsInit == 0) {
      Init_Free(FL_ObjWin(obj));
      IsInit = 1;
    }
    if((sim_x != cState.map.x) || (sim_y!=cState.map.y) || (view->screen->h != cState.h) ||
	(view->screen->w != cState.w) || (sim_z != cState.zoom))  {
    /* redraw the light grey background */
    /* pthread_mutex_lock(&sem); */
    XSetForeground(disp, gcFree, fl_get_pixel(FL_WHITE));
    XFillRectangle(disp, FL_ObjWin(obj), gcFree, obj->x, obj->y, obj->w, obj->h);
    /* pthread_mutex_unlock(&sem); */
    /* draw the map */
      cState.x = view->screen->x;
      cState.y = view->screen->y;
      cState.w = view->screen->w;
      cState.h = view->screen->h;
      sim_x = cState.map.x;
      sim_y = cState.map.y;
      sim_z = cState.zoom;
      DrawMap(FL_ObjWin(obj),TRUE);
    
    /* draw the robot */
    CalcPosition();
    DrawObs(FL_ObjWin(obj),TRUE);
    DrawRobot(FL_ObjWin(obj), TRUE);
    if(cState.mouse == IS_RESIZE_MAP)  {
      /* pthread_mutex_lock(&sem); */
      nowRatio = ((float)(abs(cState.mx-temp_mx)))/((float)(abs(cState.my-temp_my)));
      beforeRatio = ((float)(cState.w))/((float)(cState.h));
      fl_winset(FL_ObjWin(view->screen));
      if(nowRatio > beforeRatio)
        fl_rect(cState.mx,cState.my,abs(cState.mx-temp_mx),abs(cState.mx-temp_mx)/beforeRatio,FL_RED);
      else
        fl_rect(cState.mx,cState.my,abs(cState.my-temp_my)*beforeRatio,abs(cState.my-temp_my),FL_RED);

      /*fl_rect(cState.mx,cState.my,abs(cState.mx-temp_mx),abs(cState.my-temp_my),FL_RED);*/
      /* pthread_mutex_unlock(&sem); */
    }
     
    } else {
        DrawMap(FL_ObjWin(obj),FALSE);
        DrawObs(FL_ObjWin(obj),FALSE);
        DrawRobot(FL_ObjWin(obj),FALSE);
        CalcPosition();
        DrawObs(FL_ObjWin(obj),TRUE);
        DrawRobot(FL_ObjWin(obj),TRUE);
    }
    GetSensorData();
    break;
  case FL_KEYBOARD:
    switch (key)  {
      case 17:
      case 81:
      case 113:
        /* Q in all its forms */
        B_Exit();
        break;
      case 23:
      case 87:
      case 119:
        /* W in all its forms */
        B_World();
        break;
      case 13:
      case 77:
      case 109:
        /* A in all its forms */
        B_Maze();
        break;
      case 16:
      case 80:
      case 112:
        B_Param();
        break;
      case 26:
      case 43:
      case 90:
      case 122:
        B_Zoom();
        break;
      case 21:
      case 45:
      case 85:
      case 117:
        B_Unzoom();
        break;
      case 65362:
        /* cursor up */
        robotSpeed[FIndex(pthread_self())].v += 0.1;
 	break;
      case 65361:
        /* cursor left */
        robot[FIndex(pthread_self())].radians += 0.02;
        if(robot[FIndex(pthread_self())].radians > (2*PI))
	  robot[FIndex(pthread_self())].radians -= 2*PI;
	break;
      case 65363:
	/* cursor right */
	robot[FIndex(pthread_self())].radians -= 0.02;
	if(robot[FIndex(pthread_self())].radians < 0)
	  robot[FIndex(pthread_self())].radians += 2*PI;
  	break;
      case 65364:
	/* cursor down */
	robotSpeed[FIndex(pthread_self())].v -= 0.1;
	break;
      default:
	break;
    }
    break;
  case FL_STEP: 
    break;
  case FL_PUSH:
    if(key == 1) {
      if(dbg)
        fprintf(stderr, "Button 1 pressed\n");
      edge = (ROBOT_RADIUS + 5*ROBOT_RADIUS*ROBOT_PSCALE) / cState.zoom + 5;
      cState.b1 = 1;
      cState.mx = mx;
      if(mx < (cState.x + edge)) 
	cState.mx = cState.x+edge;
      if(mx < (cState.x + cState.w - edge))
	cState.mx = cState.x +cState.w - edge;
      cState.my = my;
      if(my > (cState.y + edge)) 
	cState.my = cState.y + edge;
      if(my < (cState.y + cState.h - edge))
	cState.my = cState.y + cState.h - edge;
      robi = -1;
      do
      { robi++;
        mxDiff = (int)((robot[robi].x-cState.map.x)/cState.zoom+cState.x - mx);
        myDiff = (int)((robot[robi].y-cState.map.y)/cState.zoom+cState.y - my);
        if(sqrt(mxDiff*mxDiff + myDiff*myDiff) < ROBOT_RADIUS/cState.zoom) {
 	  if(cState.mouse == DELETE_ROBOT)  {
            fprintf(stderr,"KILLING THREAD %ld\n", robot_id.index[robi]);
            pthread_kill(robot_id.r[robi], SIGSTOP);
            robot_id.index[robi] = -1;
            sim_x = -1;
	  } else cState.mouse = IS_MOVE_ROBOT;
        } else if(sqrt(mxDiff*mxDiff + myDiff*myDiff) < edge) {
	        cState.mouse = IS_ROTATE_ROBOT;
        }
      } while (robi < robot_count && (cState.mouse == NO_MOVE || cState.mouse == DELETE_ROBOT));
    } else if(key == 2) {
    //pthread_mutex_lock(&sem);
    fl_set_cursor(FL_ObjWin(view->screen), XC_spider);
    //pthread_mutex_unlock(&sem);
      
      cState.b2 = 1;
      if(cState.mouse !=IS_MOVE_MAP)  { 
        cState.mx = mx;
        cState.my = my;
      }
      cState.mouse = IS_MOVE_MAP;
      if(dbg) fprintf(stderr, "Button 2 pressed\n");
    } else if(key == 3) {
      sim_x = -1;
      cState.mouse = IS_RESIZE_MAP;
      cState.mx = mx;
      cState.my = my;
      if(dbg)
        fprintf(stderr, "Button 3 pressed\n");
    } else {
      if(dbg)
        fprintf(stderr, "**Error -- no key pressed??\n");
    }
    break;
  case FL_RELEASE:
    //pthread_mutex_lock(&sem);
    fl_set_cursor(FL_ObjWin(view->screen), XC_arrow);
    //pthread_mutex_unlock(&sem);
    cState.mouse = NO_MOVE;
    if(key == 1) {
      if(dbg)
      fprintf(stderr, "Button 1 released\n");
      cState.b1 = 0;
      cState.mx = mx;
      cState.my = my;
    } else if(key == 2) {
      if(dbg)
      fprintf(stderr, "Button 2 released\n");
      cState.b2 = 0;
      cState.mx = mx;
      cState.my = my;
    } else if(key == 3) {
      if(dbg)
      fprintf(stderr, "Button 3 released\n");
      cState.map.x = (cState.mx-cState.x)*cState.zoom +cState.map.x;
      cState.map.y = (cState.my-cState.y)*cState.zoom +cState.map.y;
      nowRatio = ((float)(abs(cState.mx-mx)))/((float)(abs(cState.my-my)));
      beforeRatio = ((float)(cState.w))/((float)(cState.h));
      if(nowRatio>beforeRatio)
        cState.zoom = fabs(cState.mx-mx)/cState.w*cState.zoom;
      else
        cState.zoom = fabs(cState.my-my)/cState.h*cState.zoom;
      //OSSemP(&sf);
      sim_x = -1;
      //pthread_mutex_lock(&sem);
      fl_redraw_object(view->screen);
      //pthread_mutex_unlock(&sem);
      //OSSemV(&sf);
    } else {
      if(dbg)
      fprintf(stderr, "**Error -- no key pressed??\n");
    }
    break;
  case FL_MOTION:
    break;
  case FL_MOUSE:
    edge = (ROBOT_RADIUS + 2*ROBOT_RADIUS*ROBOT_PSCALE)/cState.zoom;
    if(cState.mouse == IS_MOVE_ROBOT) {
	if((mx > (obj->x + edge)) && (mx < (obj->x + obj->w - edge))) {
	  robot[robi].x = (int)((mx-cState.x)*cState.zoom+cState.map.x);
	  X_rob_[robi] = robot[robi].x;
	} else {
          cState.map.x -= (int)((cState.mx - mx)*cState.zoom);
	  robot[robi].x = (int)((cState.mx-cState.x)*cState.zoom+cState.map.x);
	  X_rob_[robi] = robot[robi].x;
	  if(cState.map.x < 0)  {
	    cState.map.x = 0;
	    robot[robi].x = (int)(edge*cState.zoom);
	  X_rob_[robi] = robot[robi].x;
          } else if(cState.map.x > (cState.map.w - cState.w*cState.zoom)) {
	    cState.map.x = cState.map.w - cState.w*cState.zoom;
	    robot[robi].x = cState.map.w - edge*cState.zoom;
	  X_rob_[robi] = robot[robi].x;
 	  }
        }
	if((my > (obj->y + edge)) && (my < (obj->y + obj->h - edge))) {
	  robot[robi].y = (int)((my-cState.y)*cState.zoom+cState.map.y);
	  Y_rob_[robi] = robot[robi].y;
	} else {
          cState.map.y -= (int)((cState.my - my)*cState.zoom);
          robot[robi].y = (int)((cState.my-cState.y)*cState.zoom+cState.map.y);
	  Y_rob_[robi] = robot[robi].y;
          if(cState.map.y < 0) {
            cState.map.y = 0;
	    robot[robi].y = (int)(edge*cState.zoom);
	  Y_rob_[robi] = robot[robi].y;
          } else if(cState.map.y > (cState.map.h - cState.h*cState.zoom))  {
	    cState.map.y = cState.map.h - cState.h*cState.zoom;
	    robot[robi].y = cState.map.h - edge*cState.zoom;
	  Y_rob_[robi] = robot[robi].y;
	  }
        }
        if((mx > (cState.x + edge)) && (mx < (cState.x + cState.w - edge)))
	  cState.mx = mx;
        if((my > (cState.y + edge)) && (my < (cState.y + cState.h - edge)))
	  cState.my = my;
	if (dbg) fprintf(stderr, "Moving robot\n");
	sim_x = -1;
        //pthread_mutex_lock(&sem);
	fl_redraw_object(obj);
        //pthread_mutex_unlock(&sem);
    } else if(cState.mouse == IS_ROTATE_ROBOT) {
      if((cState.mx != mx) || (cState.my != my)) {
	robot[robi].radians = asin(((robot[robi].y-cState.map.y)/cState.zoom +cState.y- my)/
                              sqrt(SIMsqr((robot[robi].x-cState.map.x)/cState.zoom+cState.x- mx) +
                              SIMsqr((robot[robi].y-cState.map.y)/cState.zoom  +cState.y- my)));
	if((mx - (robot[robi].x-cState.map.x)/cState.zoom - cState.x) < 0) {
	  robot[robi].radians = PI - robot[robi].radians;
	}
	sim_x = -1;
        //pthread_mutex_lock(&sem);
	fl_redraw_object(obj);
        //pthread_mutex_unlock(&sem);
      }
    } else if(cState.mouse == IS_MOVE_MAP) {
      mxDiff = mx - cState.mx;
      myDiff = my - cState.my;
      if(((cState.map.x - mxDiff*cState.zoom) > 0) && ((cState.map.x - mxDiff*cState.zoom) < (cState.map.w - cState.w*cState.zoom))) {
	cState.map.x = cState.map.x - mxDiff*cState.zoom;
        cState.mx = mx;
      }
      if(((cState.map.y - myDiff*cState.zoom) > 0) && ((cState.map.y - mxDiff*cState.zoom) < (cState.map.h - cState.h*cState.zoom))) {
	cState.map.y = cState.map.y - myDiff*cState.zoom;
        cState.my = my;
      }
      //pthread_mutex_lock(&sem);
      fl_redraw_object(obj);
      //pthread_mutex_unlock(&sem);
    } else if(cState.mouse == IS_RESIZE_MAP) {
      temp_mx = mx;
      temp_my = my;
      //OSSemP(&sf);
	sim_x = -1;
      //pthread_mutex_lock(&sem);
      fl_redraw_object(view->screen);
      //pthread_mutex_unlock(&sem);
      //OSSemV(&sf);
    }
    break;
  }
  //pthread_mutex_unlock(&semview);
  return 0;
}

float SIMsqr(float x) {
  return x*x;
}
    










