#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <forms.h>
#include "eyesim.h"
#include "protos.h"

BumpHandle bumpItLeft = 0, bumpItRight = 0;
BumpHandle BUMP_Sensor[MAX_ROBOTS][MaxNumOfBUMP];

BumpHandle BUMPInit(DeviceSemantics semantics)  {
  int i=0;
  InitialiseLCD();

  display_screen();
  if((semantics == BUMP_LEFT) && (bumpItLeft == 0)) {
    bumpItLeft = rand() % 10 + 1;
    i = bumpItLeft;
  }
  if ((semantics == BUMP_RIGHT) && (bumpItRight == 0))  {
    bumpItRight =  rand() % 10 + 11;
    i = bumpItLeft;
  }
  strcpy(BUMPinput[robotindex()],"BUMP (");
  if(bumpItLeft !=0)
    strcat(BUMPinput[robotindex()]," BUMP_LEFT");
  if (bumpItRight !=0)
    strcat(BUMPinput[robotindex()]," BUMP_RIGHT");
  strcat(BUMPinput[robotindex()]," )");
  check_forms_redraw_screen();
  return i;
}

int BUMPRelease(BumpHandle handle) {
  if((handle != bumpItLeft) && (handle != bumpItRight))
    return -1;
  else if (handle == bumpItLeft)
    bumpItLeft = 0;
  else bumpItRight = 0;
  check_forms();
  return 0;
}

int
BUMPCheck(BumpHandle handle, int *timestamp)
{
  float thisAngle = 0;

  if((handle != bumpItLeft) && (handle != bumpItRight))
    return -1;
  if(vw_robots[robotindex()].stalled)  {
    if(handle == bumpItLeft)
      thisAngle = fabs(M_PI_2 + robot[robotindex()].radians - bumperAngle[robotindex()]);
    else
      thisAngle = fabs(-M_PI_2 + robot[robotindex()].radians - bumperAngle[robotindex()]);
    if(thisAngle > M_PI)
      thisAngle = fabs(2*M_PI - thisAngle);
    *timestamp = (int)(thisAngle*250.0);
    check_forms_redraw_screen();
    return 0;
  } else {
    check_forms_redraw_screen();
    return 1;
  }
}

