/* debugprint.c
 * Author: Daniel Hoey
 * Date: 7/4/2000
 * Description: Contains print function for easier debugging
 *              (especially for multi threading)
 * Last Modification: 10/4/2000
*/

#include <stdio.h>
#include <stdarg.h>
#include <pthread.h>
#include "protos.h"
#include "debugprint.h"

static int debuglevel = 1;

void
eyesim_debugprint(char *string, char *string2)
{

#if defined(DEBUG_NOT_XSIM)
  if (string = "xsim.c")
    return;
#endif

  fprintf(stderr, "%s: %s (robot %d)\n", string, string2, OSMachineID());
  fflush(NULL);
  return;
}

void
eyesim_robotprint(char *string, int id)
{
  fprintf(stderr, "robot %d: %s\n", id, string);
  fflush(NULL);
  return;
}

void
eyesim_debug(int level, const char *file, const char *function,
      const char *format, ...)
{
  va_list vargs;

  if (level > debuglevel)
    return;

  fprintf(stderr, "%s(%s): ", file, function);

  va_start(vargs,format);
  vfprintf(stderr,format,vargs);
  va_end(vargs);
  fprintf(stderr, "\n");
  fflush(NULL);
}
