/* debugprint.h
 * Author: Daniel Hoey
 * Date: 7/4/2000
 * Description: Contains print function for easier debugging
 *              (especially for multi threading)
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "kern.h"

void eyesim_debugprint(char *string, char *string2);
void eyesim_robotprint(char *string, int robot_id);
void eyesim_debug(int level, const char *file, const char *function,
                  const char *fmt, ...);

#if defined(DEBUG)
#  define TRACK() eyesim_debugprint(__FILE__, __FUNCTION__)
#  define TRACK1(str) eyesim_debugprint(__FILE__, __FUNCTION__ str)
#  define TRACKROBOT(str, robot_id) eyesim_robotprint(str, robot_id)
#  define DBG(level, fmt, args...) eyesim_debug(level, __FILE__, __FUNCTION__,\
                                                fmt, ##args)
#else
#  define TRACK()
#  define TRACK1(str)
#  define TRACKROBOT(str, robot_id)
#  define DBG(level, fmt, args...)
#endif

#  define STUB() do { eyesim_debug(0, __FILE__, __FUNCTION__, "STUB called"); \
                      check_forms_redraw_screen(); } while (0)

#ifdef __cplusplus
}
#endif
