#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>

#include "forms.h"
#include "eyesim.h"
#include "protos.h"
#include "LCDDisp.h"
#include "helpscreen.h"
#include "errorChange.h"

#define DELETE_ROBOT    5

int ROBOT_RADIUS = 75;
Robot robotStartPos[MAX_ROBOTS];
char fdata[50], tmp[50], tmp1[50];
struct timezone z;
BOOL dontMove = TRUE, helpBool = FALSE;
int dbg = 0;


void eyesim_ClearScreen(void)
{
  fl_hide_object(eyesim_help->showText);
  fl_set_object_label(eyesim_help->title,"");
  fl_set_object_label(eyesim_help->text,"");
  fl_winset(FL_ObjWin(eyesim_help->text));
  fl_rectf(25,55,390,340,FL_COL1);
}

void eyesim_ContinuousPause()
{
  while(dontMove)
  {
    fl_check_forms();
    gettimeofday(&checkOut,&z);
  }
  pthread_cond_broadcast(&pause_button);
}

/* callbacks and freeobj handles for form eyebot */
void eyesim_B_Exit()
{
  int i;

  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"EXIT button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button can used to quit the simulator. ");
    XFlush(disp);
  } else {
    /* pthread_exit(0); */
    for(i=0;i<robot_count;i++)
      if(NO_THREAD != robot_id.index[i])
        pthread_kill(robot_id.index[i], SIGCONT);
    exit(0);
  }
}

void eyesim_B_World()
{
  char *file;

  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"WORLD button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to load a `*.wld' file, which\n "
       "contains the dimensions of the world you select.\n"
       "Henceforth, the eyebot will be limited to the dimensions \n"
       "set by the current world.");
    XFlush(disp);
  } else {
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    file = (char *)fl_show_fselector("Load World", PKGDATADIR "/worlds",
                                     "*.wld", "");
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    World(file);
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
  }
}


void eyesim_B_Maze() {
  char *file;

  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"MAZE button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to load a `*.maz' file, which\n "
       "is the maze map of the world to be loaded.\n"
       "Henceforth, the eyebot will be limited to the dimensions \n"
       "set by the current maze world. See eg1.maz for character \n"
       "to map size specification.\n"
       "Default is 400\n"
       "\n"
       "'S' for starting position with wall directly underneath it\n"
       "'s' for starting position without.\n"
       "See eg2 for 's' usage\n");
    XFlush(disp);
  } else {
    sim_x = -1;
    file = (char *)fl_show_fselector("Load Maze", PKGDATADIR "/worlds",
                                     "*.maz", "");
    sim_x = -1;
    Maze(file);
    fl_redraw_object(eyesim_view->screen);
  }
}


void eyesim_B_Param()
{
  char *file;

  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"PARAM button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to load a `*.p' file, which\n "
       "contains the parameters for the eyebot.\n\n"
       "Unfortunately, the parameter function has not yet\n"
       "been implemented and hence, you will not be able to\n"
       "load a param file.");
    XFlush(disp);
  } else {
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    file = (char *)fl_show_fselector("Load Param", ".", "*.p", "eyesim.p");
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    if (file != (char *)NULL)
      eyesim_Param(file);
  }
}


void eyesim_Param(char *file) {
  char ch;
  char filename[50];
  int cnt, i, rcount=0;
  FILE *fp;

  if ((fp = fopen(file,"r")) == NULL) {
    if (dbg) fprintf(stderr, "\nCannot open %s\n", file);
    return;
  }

  NumOfIR = 0;
  NumOfPSD = 0;
  NumOfBUMP = 0;
  while (!feof(fp)) {
    fscanf(fp, "%[^\n]", fdata);
    if (!feof(fp))
      fscanf(fp, "%c", &ch);
    if (*fdata != '\0') {
      cnt = 0;
      while (isspace(fdata[cnt]))
        cnt++;

      if (fdata[cnt] != '#') {
        if (!strncmp(fdata+cnt, "name", 4))
          sscanf(fdata+cnt, "%s %s", tmp, name);
        else if (!strncmp(fdata+cnt, "diameter", 8)) {
          sscanf(fdata+cnt, "%s %d", tmp, &ROBOT_RADIUS);
          ROBOT_RADIUS /= 2;
        } else if (!strncmp(fdata+cnt, "speed", 5))
          sscanf(fdata+cnt, "%s %f", tmp, &vwLimit.v);
        else if (!strncmp(fdata+cnt, "turn", 4))
          sscanf(fdata+cnt, "%s %f", tmp, &vwLimit.w);
        else if (!strncmp(fdata+cnt, "world", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          World(filename);
        } else if (!strncmp(fdata+cnt, "maze", 4)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          Maze(filename);
        } else if (!strncmp(fdata+cnt, "debug", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          if (!strncmp(filename, "on", 2))
            dbg = 1;
          else if (!strncmp(filename, "off", 3))
            dbg = 0;
        } else if (!strncmp(fdata+cnt, "pause", 5)) {
          sscanf(fdata+cnt, "%s %s", tmp, filename);
          if (strncmp(filename, "off", 3) == 0)  {
            dontMove = FALSE;

            fl_set_button(eyesim_view->Pause,1);

          }
        } else if (!strncmp(fdata+cnt, "psd", 3)) {
          if (NumOfPSD >= MaxNumOfPSD) {
            if (dbg) fprintf(stderr,"Exceed max. number of PSD sensors\n");
          } else {
            sscanf(fdata+cnt, "%s %s %d %lf %d %lf", tmp, PSDSen[0][NumOfPSD].name, \
                        &PSDSen[0][NumOfPSD].semantic, &PSDSen[0][NumOfPSD].t,  &PSDSen[0][NumOfPSD].d,  &PSDSen[0][NumOfPSD].a);
            PSDSen[0][NumOfPSD].t = DegToRad(PSDSen[0][NumOfPSD].t);
            PSDSen[0][NumOfPSD].a = DegToRad(PSDSen[0][NumOfPSD].a);
            NumOfPSD++;
          }
        } else if (!strncmp(fdata+cnt, "ir", 2)) {
          if (NumOfIR >= MaxNumOfIR) {
            if(dbg) fprintf(stderr,"Exceed max. number of IR sensors\n");
          } else {
            sscanf(fdata+cnt, "%s %s %d %lf %d %lf", tmp, IRSen[0][NumOfIR].name,
                   &IRSen[0][NumOfIR].semantic, &IRSen[0][NumOfIR].t,
                   &IRSen[0][NumOfIR].d,  &IRSen[0][NumOfIR].a);
            IRSen[0][NumOfIR].t = DegToRad(IRSen[0][NumOfIR].t);
            IRSen[0][NumOfIR].a = DegToRad(IRSen[0][NumOfIR].a);
            NumOfIR++;
          }
        } else if (!strncmp(fdata+cnt, "bump", 4)) {
           sscanf(fdata+cnt, "%s %s %d %lf %lf", tmp, BUMPSen[0][NumOfBUMP].name,
                  &BUMPSen[0][NumOfBUMP].semantic, &BUMPSen[0][NumOfBUMP].t,
                  &BUMPSen[0][NumOfBUMP].a);
           BUMPSen[0][NumOfIR].t = DegToRad(BUMPSen[0][NumOfIR].t);
           BUMPSen[0][NumOfIR].a = DegToRad(BUMPSen[0][NumOfIR].a);
           NumOfBUMP++;
        } else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"psd") != NULL))  {
           sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
           if(i>100)
             i = 100;
           err_psd = (double)i/100;
        } else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"ir") != NULL))  {
           sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
           if(i>100)
             i = 100;
           err_ir = (double)i/100;
        } else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"line") != NULL))  {
           sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
           if(i>100)
             i = 100;
           err_for = (double)i/100;
        } else if ((strstr(fdata+cnt,"error") != NULL) && (strstr(fdata+cnt,"rota") != NULL))  {
           sscanf(fdata+cnt, "%s %s %d",tmp, tmp1, &i);
           if(i>100)
             i = 100;
           err_rot = (double)i/100;
        } else if (strstr(fdata+cnt,"robots") != NULL) {
           sscanf(fdata+cnt, "%s %d",tmp, &robot_id.Num_robot);
        } else if (strstr(fdata+cnt,"start") != NULL) {
           sscanf(fdata+cnt, "%s %f %f %f",tmp,  &(X_rob_[rcount]), &(Y_rob_[rcount]),
                                        &(robot[rcount].radians));
           robot[rcount].x = X_rob_[rcount];
           Y_rob_[rcount] = cState.map.h - Y_rob_[rcount];
           robot[rcount].y = Y_rob_[rcount];
           rcount++;
        }
        else {
           fprintf(stderr, "Error in format: %s\n", fdata);
        }
        *fdata = '\0';
      }
    }
  }
  fclose(fp);
  sim_x = -1;

  fl_redraw_object(eyesim_view->screen);

}


void eyesim_B_Zoom()
{
  if(helpBool)  {
    eyesim_ClearScreen();

    fl_set_object_label(eyesim_help->title,"ZOOM IN button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to enlarge the viewable map, \n "
       "allowing you to view the map in more detail. \n"
       "The zoom factor is currently set to 0.5, so the\n"
       "objects in the map are viewed in more detail by \n"
       "twenty percent. \n");
    XFlush(disp);

  } else {
    if(cState.zoom >= 0.6) {
      cState.zoom -= 0.5;
      cState.map.x += (long)((robot[robotindex()].x-cState.map.x)*0.5/(cState.zoom+0.5));
      cState.map.y += (long)((robot[robotindex()].y-cState.map.y)*0.5/(cState.zoom+0.5));
    }
  }
  if (dbg) fprintf(stderr, "Zoom %2.1f\n", cState.zoom);
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_B_Unzoom()
{
  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"ZOOM OUT button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to shrink the viewable map, \n "
       "allowing you to view more of the map at a time. \n"
       "The zoom out factor is currently set to 0.5, so \n"
       "everytime you click the button, you see twenty percent\n"
       "more of the map.");
    XFlush(disp);
  } else {
    if((cState.map.h < (cState.h*cState.zoom)) && (cState.map.w < (cState.w*cState.zoom)))  {
      if (dbg) fprintf(stderr,"Maximum zoom out obtained\n");
    } else {
      cState.zoom += 0.5;
      cState.map.x -= (long)((robot[robotindex()].x-cState.map.x)*0.5/(cState.zoom-0.5));
      cState.map.y -= (long)((robot[robotindex()].y-cState.map.y)*0.5/(cState.zoom-0.5));
      if(cState.map.x<0)
        cState.map.x =0;
      else if((cState.map.x + cState.w*cState.zoom) > cState.map.w)
        cState.map.x = cState.map.w - cState.w*cState.zoom;
      if(cState.map.y < 0)
        cState.map.y = 0;
      else if((cState.map.y + cState.h*cState.zoom) > cState.map.h)
        cState.map.y = cState.map.h - cState.h*cState.zoom;
  /*    OSSemP(&sf); */
      sim_x = -1;
      fl_redraw_object(eyesim_view->screen);
   /*   OSSemV(&sf); */
    }
  }
  if (dbg) fprintf(stderr, "Unzoom %2.1f\n", cState.zoom);
}

void
eyesim_B_Unzoom_full(void)
{
  while((cState.map.w > (cState.w*cState.zoom))
        || (cState.map.h > (cState.h*cState.zoom)))
    cState.zoom += 0.5;
  eyesim_menuCENTER(eyesim_view->Center,0);
}

void eyesim_menuCENTER(FL_OBJECT *ob, long data)
{
  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"CENTER button.");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to center the map around the \n "
       "robot.  If the robot is too close to the edge of the\n"
       "map, it centers the map as close to the edge of the map\n"
       "possible.");
    XFlush(disp);
  } else {
    cState.map.x = robot[0].x - cState.w/2*cState.zoom;
    cState.map.y = robot[0].y - cState.h/2*cState.zoom;
    if (cState.map.x < 0)
      cState.map.x = 0;
    else if((cState.map.x + cState.w*cState.zoom) > cState.map.w)
      cState.map.x = cState.map.w - cState.w*cState.zoom;
    if (cState.map.y < 0)
      cState.map.y = 0;
    else if((cState.map.y + cState.h*cState.zoom) > cState.map.h)
      cState.map.y = cState.map.h - cState.h*cState.zoom;
    }
  if (dbg) fprintf(stderr, "Center\n");
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_B_Pause(FL_OBJECT *ob, long data)
{
  if(helpBool)
  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"PAUSE button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
       "This button is used to pause and unpause the whole\n "
       "simulator.  While the simulator is paused - you may\n"
       "still CENTER/ZOOM/UNZOOM the map and move the drag\n"
       "the robot to a different location using the mouse.");
    fl_set_button(eyesim_view->Pause,0);
    fl_redraw_object(eyesim_view->Pause);
    XFlush(disp);
  }
  else
  {
    dontMove = !dontMove;
    eyesim_ContinuousPause();
    gettimeofday(&checkOut,&z);
    //pthread_cond_broadcast(&pause_button);
  }
}

void eyesim_B_Screen(FL_OBJECT *ob, long data)
{
  if (dbg) fprintf(stderr, "Screen\n");
}

void eyesim_B_Help(FL_OBJECT *ob, long data)
{
  dontMove = TRUE;
  fl_show_form(eyesim_help->helpscreen, FL_PLACE_MOUSE, FL_FULLBORDER, "Help");
  eyesim_ClearScreen();
  fl_set_cursor(FL_ObjWin(eyesim_fd_eyebot->LCDDisplay),XC_question_arrow);
  fl_set_cursor(FL_ObjWin(eyesim_view->screen),XC_question_arrow);
  fl_set_object_label(eyesim_help->title,"HELP");
  fl_set_object_label(eyesim_help->text,"\n\n\n"
        "Click on any button within this window to use the help\n"
        "or else click on any other simulator button to have that\n"
        "particular button explained.\n\n"
        "About  - details about the simulator              \n"
        "Select - nothing right now...                             \n"
        "Search - search for a particular keyword        \n"
        "Index  - goto index to search for a keyword\n"
        "Exit   - quit the help                                       ");
  helpBool = TRUE;
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
  eyesim_ContinuousPause();
}

void eyesim_B_Refresh(FL_OBJECT *obj, long data)
{
  fl_redraw_form(eyesim_view->viewscreen);
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_menuFILE(FL_OBJECT *ob, long data)
{
  int i;
  char *tempstr;

  i = fl_get_menu(ob);

  switch(i)  {
  case 1:
    eyesim_B_World();
    break;
  case 2:
    eyesim_B_Maze();
    break;
  case 3:
    eyesim_B_Param();
    break;
  case 4:
    dontMove = TRUE;
    tempstr = (char *)calloc(40,sizeof(char));
    sprintf(tempstr,"%d",2*ROBOT_RADIUS);
    fl_set_input(eyesim_errchange->Robot,tempstr);
    sprintf(tempstr,"%d",startPSD_);
    fl_set_input(eyesim_errchange->psdBefore,tempstr);
    sprintf(tempstr,"%d",startPSD_ + endPSD_);
    fl_set_input(eyesim_errchange->psdAfter,tempstr);
    sprintf(tempstr,"%d",IRrange);
    fl_set_slider_value(eyesim_errchange->Forward,(double)err_for);
    fl_set_slider_value(eyesim_errchange->Rotate,(double)err_rot);
    fl_set_slider_value(eyesim_errchange->ir_err,(double)err_ir);
    fl_set_slider_value(eyesim_errchange->psd_err,(double)err_psd);
    fl_set_input(eyesim_errchange->irMax,tempstr);
    sprintf(tempstr,"%d",TrailBuffer);
    fl_set_input(eyesim_errchange->Trail,tempstr);
    fl_show_form(eyesim_errchange->paramChange, FL_PLACE_MOUSE,FL_FULLBORDER,"Parameters");
    eyesim_ContinuousPause();
    break;
  case 5:
    eyesim_B_Exit();
    break;
  default: break;
  }
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_menuGROW(FL_OBJECT *ob, long data)  {
  int i, j;

  i = fl_get_menu(ob);
  switch(i)  {
  case 1:
    if(dontMove)  {
      start_new_robot(-1);
    }
    break;
  case 2:
    if(dontMove)
      cState.mouse = DELETE_ROBOT;
    break;
  case 3:
    trail = 1;
    break;
  case 4:
    trail = 0;
    for(j=0;j<MAX_ROBOTS;j++)
      counter[j] = 0;
    break;
  default:
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    break;
  }
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_menuSHRINK(FL_OBJECT *ob, long data)  {
  int i;

  i = fl_get_menu(ob);
  switch(i)  {
  case 1:
    eyesim_B_Zoom();
    break;
  case 2:
    eyesim_B_Unzoom();
    break;
  case 3:
    eyesim_B_Unzoom_full();
    break;
  default:
    sim_x = -1;
    fl_redraw_object(eyesim_view->screen);
    break;
  }
  sim_x = -1;
  fl_redraw_object(eyesim_view->screen);
}

void eyesim_forward_cb(FL_OBJECT *ob, long data)  {
  err_for = (double)(fl_get_slider_value(ob));
}

void eyesim_rotate_cb(FL_OBJECT *ob, long data)  {
  err_rot = (double)(fl_get_slider_value(ob));
}

void eyesim_psd_cb(FL_OBJECT *ob, long data)  {
  err_psd = (double)(fl_get_slider_value(ob));
}

void eyesim_ir_cb(FL_OBJECT *ob, long data)  {
  err_ir = (double)(fl_get_slider_value(ob));
}

void eyesim_goback_cb(FL_OBJECT *ob, long data)  {
  int i;

  sscanf(fl_get_input(eyesim_errchange->psdBefore),"%d",&startPSD_);
  sscanf(fl_get_input(eyesim_errchange->psdAfter), "%d" ,&i);
  endPSD_ = i - startPSD_;
  sscanf(fl_get_input(eyesim_errchange->irMax),"%d",&IRrange);
  sscanf(fl_get_input(eyesim_errchange->Robot),"%d",&i);
  ROBOT_RADIUS = i/2;
  sscanf(fl_get_input(eyesim_errchange->Trail),"%d",&TrailBuffer);
  if(TrailBuffer > 20000)
    TrailBuffer = 20000;
  if(eyesim_view->Pause->pushed != 0)
    dontMove = FALSE;
  fl_hide_form(eyesim_errchange->paramChange);
  gettimeofday(&stepTwo, NULL);
}
