/*      $Id: eyesim.h,v 1.13 2000/08/03 10:28:58 pere Exp $       */

#ifndef FD_eyebot_h_
#define FD_eyebot_h_

#include <pthread.h>

#include "types.h"
#include "viewscreen.h"
#include "vw.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ROBOT_PSCALE 0.2
#define MAX_ROBOTS 100
#define DegToRad(deg) (deg*0.017453292)


typedef struct {
  long x1;
  long y1;
  long x2;
  long y2;
} Segment;

typedef struct {
  long x;
  long y;
} Points;

typedef struct {
  long x;
  long y;
  short theta;
} Point;

typedef struct {
  int x, y;
  float radians;
} Robot;

typedef struct {
  long x, y, lx, ly;
  long w, h;
} Map;

typedef struct {
  int x, y, w, h;
  int mx, my;
  int b1, b2, b3;
  int mouse;
  float zoom;
  Map map;
} State;

typedef struct {
        int Num_robot;
        pthread_t index[MAX_ROBOTS];
} robot_id_type;

pthread_cond_t ready2;
pthread_mutex_t semview;
extern int Init_Multi();
#define NO_THREAD ((pthread_t)-1)

extern State cState;
extern Robot robot[MAX_ROBOTS];
extern int ROBOT_RADIUS;
extern float  rot_error, for_error;
extern Robot robotStartPos[MAX_ROBOTS];
extern long mapWidth, mapHeight;
extern FD_viewscreen *eyesim_view;
extern BOOL dontMove, helpBool;
/* extern XSegment *visible;
extern NSegVisible;
*/

extern int sim_x;
extern float X_rob_[MAX_ROBOTS], Y_rob_[MAX_ROBOTS];
extern int robot_count;

/** External functions **/

extern float eyesim_sqr(float);

/** Callback routines and free object handlers **/

extern void eyesim_ClearScreen();
extern XSegment *Filter(int *);

typedef BYTE SIMimage[imagerows*imagecolumns*4];
typedef BYTE SIMcolimage[imagerows*imagecolumns*4][3];

#define MAXPOS 16
#define IMAGE_SIZE (160*120)

/* -------=< Constant for IR >=-----------*/
/*
#define NumOfIR 7
#define IR_LR_Fangle 5
#define IR_LR_Mangle 45
#define IR_LR_Bangle 90
#define IR_Backangle 180
*/

#define MaxNumOfIR 20
#define MaxNumOfPSD 20
#define MaxNumOfBUMP 20

#define NumOfObstacles 20

/* -------=< Global Variables >=---------- */

extern int keystatus, xDepth, scrolling, lcdline, lcdpos, imageSize, screen_num;
extern int colortable[64], startPSD_, endPSD_;
extern int IRrange, IRlist[MaxNumOfIR], IRcount, TrailBuffer;
extern BOOL **lcdpixel, initial[MAX_ROBOTS];
extern float bumperAngle[MAX_ROBOTS];
extern char **text, *compareinput, *sText[MAX_ROBOTS], *IRinput[MAX_ROBOTS], *BUMPinput[MAX_ROBOTS], *PSDinput;
extern Display *disp;
extern XImage *ximage;
extern Window win;
extern XGCValues values;
extern Colormap cmap;
extern pthread_cond_t ready, pause_button;
extern GC gc;
extern BYTE ximagemem[IMAGE_SIZE*4];
extern struct timeval timePast[MAX_ROBOTS], stepTwo;
extern struct timeval checkOut, timeEstimate[MAX_ROBOTS];
extern float err_rot, err_for, err_psd, err_ir;
extern char name[20];
extern SpeedType vwLimit;
extern int NumOfBUMP, NumOfIR, NumOfPSD, trail, counter[MAX_ROBOTS];
extern IRHandle IR_Sensor[MAX_ROBOTS][MaxNumOfIR];
extern BumpHandle BUMP_Sensor[MAX_ROBOTS][MaxNumOfBUMP];
extern int BUMP_detect[MAX_ROBOTS][MaxNumOfBUMP];
extern int IR_detect[MAX_ROBOTS][MaxNumOfIR];
extern int PSD_detect[MAX_ROBOTS][MaxNumOfIR];
extern PSDHandle PSD_Sensor[MAX_ROBOTS][MaxNumOfPSD];
extern SensorType BUMPSen[MAX_ROBOTS][MaxNumOfBUMP];
extern SensorType IRSen[MAX_ROBOTS][MaxNumOfIR];
extern SensorType PSDSen[MAX_ROBOTS][MaxNumOfPSD];
extern int mainthread;
extern struct sem sf;
extern int dbg;

extern robot_id_type robot_id;
extern pthread_mutex_t sem, semview;

/********* Miscellaneous functions - `global.c' *************/

extern int eyesim_NewImage(int w, int h);
extern void eyesim_DoText();
extern int printf(const char *, ...);
extern void (*RawToX)(BYTE *, void *);
extern void CalcXferMode();
extern void InitialiseLCD();
extern void (*GetImage)(BYTE *);
extern void RawTo24BitX(BYTE *, int *);
extern void RawTo16BitX(BYTE *, unsigned short *);
extern void RawTo8BitX(BYTE *, BYTE *);
extern void xqc_createpalette(Colormap );
extern char *eyesim_find_file(const char *filename);

extern int first_robot();
extern int robotindex(void);
extern int start_new_robot(int id);
extern int Init();
extern void ThreadFork();

extern void new_obstacle(int x, int y);
extern void remove_obstacles(void);

struct vw_robot_info
{
  SpeedType speed;
  VWHandle hiddenhandle;
  BOOL command;
  BOOL initiate;
  BOOL stalled;
  float distest;
  float angleest;
};

extern struct vw_robot_info vw_robots[MAX_ROBOTS];

extern int VW_SetPosition(int robotid, meter x, meter y, radians phi);
extern int VW_GetPosition(int robotid, PositionType* pos);

/************ Updating screen - 'viewscreen.c' **************/

extern void check_forms(void);
extern void check_forms_redraw_screen(void);
extern void display_screen(void);
extern void redraw_screen(void);

/************ Map handling - 'map.c' **************/

extern Segment *get_current_map(int *count);
extern void World(char *file);
extern void Maze(char *file);


/********* Camera support nocam.c / cam3dsim.c / .. *******/

extern void CAMSIM_addobject(int id);
extern void CAMSIM_removeobject(int num);
extern void CAMSIM_newmap(Segment *wld, int num);

extern Window eyesim_show_image(Window window, int robotid, BYTE *ibuffer,
                         int width, int height,
                         int swidth, int sheight,
                         int xoff, int yoff,
                         int flipped);

#ifdef __cplusplus
}
#endif

#endif /* FD_eyebot_h_ */


