#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <forms.h>
#include <math.h>
#include <ctype.h>
#include <sys/time.h>
#include <unistd.h>
#include <assert.h>

#include "LCDDisp.h"
#include "protos.h"
#include "eyesim.h"
#include "helpscreen.h"

Display * disp;
Window  win;
XGCValues values;
Colormap cmap;
XImage *ximage;
BYTE ximagemem[IMAGE_SIZE*4];
GC gc;
int screen_num, xDepth, imageSize = IMAGE_SIZE;
int colortable[64];
struct timezone z;
int keystatus, scrolling, lcdline, lcdpos;
char **text, *compareinput, *BUMPinput[MAX_ROBOTS], *PSDinput;
FD_EyeBotLCD *eyesim_fd_eyebot;
float bumperAngle[MAX_ROBOTS];
BOOL **lcdpixel = NULL;


void eyesim_DoText()  {
  assert(NULL != sText[0]);
  strcpy(sText[0],"X  Y  PHI\n");
  strcat(sText[0],PSDinput);
  strcat(sText[0],"\n");
  strcat(sText[0],IRinput[0]);
  strcat(sText[0],"\n");
  strcat(sText[0],BUMPinput[0]);
  OSSemP(&sf);
  fl_set_object_lcol(eyesim_view->screenText,FL_COL1);
  fl_set_object_label(eyesim_view->screenText,sText[0]);
  fl_set_object_lcol(eyesim_view->screenText,FL_BLACK);
  OSSemV(&sf);
}

int OSGetAD(int mode){
  check_forms();
  return 0;
}

int AUCaptureMic() {
  int i;
  check_forms();
  i = rand() % 500;
  return i;
}

int AUCheckTone() {return 1;}

int AUBeep() {
  OSSemP(&sf);
  fl_ringbell(0);
  OSSemV(&sf);
  return 0;
}


int eyesim_NewImage(int w, int h)
{
    if (ximage == NULL || w != ximage -> width || h != ximage -> height)
    {
        if (ximage != NULL)
            XDestroyImage(ximage);

        ximage = XCreateImage(disp,
                              DefaultVisual(disp,screen_num),
                              xDepth,
                              ZPixmap,
                              0,
                              &ximagemem[0],
                              w,
                              h,
                              8,
                              0);
        return 1;
    }

    return 0;
}

void (*RawToX)();

void eyesim_KEY_cb(FL_OBJECT *ob, long data)  {
  char *t;
  if(helpBool)  {
    eyesim_ClearScreen();
    t = (char *)calloc(40,sizeof(char));
    sprintf(t,"KEY %d button",1+(int)(log10(1+data)/log10(4)));
    fl_set_object_label(eyesim_help->title,t);
    fl_set_object_label(eyesim_help->text,"\n\n\n"
        "These buttons may be used for user input if your\n."
        "program supports it.  From left to right, the keys\n"
        "represent KEY1, KEY2, KEY3 and KEY4.");
  } else
    keystatus = data;
}

void eyesim_POWEROFF(FL_OBJECT *ob, long data)  {
  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"EXIT button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
        "This button is used to quit from the simulator.");
    fl_set_button(eyesim_fd_eyebot->POWER,0);
    fl_redraw_object(eyesim_fd_eyebot->POWER);
  } else {
    if((scrolling & (GRAPHICS >> 1)) != 0)  {
      CAMRelease();
    }
    exit(0);
  }
}

void eyesim_RESET_cb(FL_OBJECT *ob, long data)  {
  if(helpBool)  {
    eyesim_ClearScreen();
    fl_set_object_label(eyesim_help->title,"RESET button");
    fl_set_object_label(eyesim_help->text,"\n\n\n"
        "This button currently only clears the LCD Display.");
  } else
    LCDClear();
}

void RawTo8BitX(BYTE * raw, BYTE * xbuf)
{
    int i;

    for(i = 0; i < imageSize; i++)
        *xbuf++ = colortable[(int)*raw++];
}

void RawTo16BitX(BYTE *raw, unsigned short *xbuf)
{
  int i, r,g,b;

  for(i = 0; i < imageSize; i++)
    {
      r = (int) ((*raw++ >> 3) & 0x7f) << 11;
      g = (int) ((*raw++ >> 2) & 0x7f) <<  5;
      b = (int) ((*raw++ >> 3) & 0x7f);
      *xbuf++ = (unsigned short) (r | g | b);
    }
}

void RawTo24BitX(BYTE * raw, int * xbuf)
{
    int i;
    int c;

    for(i = 0; i < imageSize; i++)
    {
        c = (int)*raw++;
        *xbuf++ = c;
    }
}

void xqc_createpalette(Colormap cmap)
{
    int i;
    int rc;
    XColor col;

    for(i = 0; i < 16; i++)
    {
        col.red =col.green = col.blue = i * 1024 * 4;
        rc = XAllocColor(disp, cmap, &col);
        colortable[i] = col.pixel;
        /* fprintf(stdout, "rc=%d %08lX\n", rc, col.pixel);*/
    }


    return;
}

void eyesim_exit_cb(FL_OBJECT *ob, long data)  {
  helpBool = FALSE;
  if(eyesim_view->Pause->pushed != 0)
    dontMove = FALSE;
  fl_set_cursor(FL_ObjWin(eyesim_fd_eyebot->LCDDisplay),XC_arrow);
  fl_set_cursor(FL_ObjWin(eyesim_view->screen),XC_arrow);
  eyesim_ClearScreen();
  fl_hide_form(eyesim_help->helpscreen);
  gettimeofday(&checkOut,&z);
}

void eyesim_about_cb(FL_OBJECT *ob, long data)  {
  eyesim_ClearScreen();

  fl_set_object_label(eyesim_help->title,"Eyebot Simulator");
  fl_set_object_label(eyesim_help->text,"\n\n\n"
    "XSIM - XWindows Robot Simulator\n"
    "version 1.1 21/01/98\n"
    "\nby Nicholas Tay (tay-nt@ee.uwa.edu.au)\n"
    "   Ghee Heng Ong (ong-g@ee.uwa.edu.au)\n"
    "   Elliot Nicholls (nicho-ej@ee.uwa.edu.au)\n"
    "\nSupervisor : Thomas Braunl (braunl@ee.uwa.edu.au)");
}

void eyesim_search_cb(FL_OBJECT *ob, long data)  {
  eyesim_ClearScreen();
  /*strncpy(compareinput,"\0",100);*/
  fl_show_object(eyesim_help->inputfield);
  fl_set_object_label(eyesim_help->title,"Search");
  fl_set_object_label(eyesim_help->text,"\n\n\n\n"
    "Search enables you to search for specific words and        \n"
    "phrases in help topics instead of browsing for information\n"
    "by category (Index).                                                             \n\n\n"
    "The search is not case specific so typing UPPER case      \n"
    "characters are not necessary, nor will it affect the                \n"
    "search                                                                                                \n"
    "\n\n\n\n"
    "Input text to search and press ENTER");
  fl_set_input(eyesim_help->inputfield,"");
}

void eyesim_index_cb(FL_OBJECT *ob, long data)  {
}

void eyesim_select_cb(FL_OBJECT *ob, long data)  {
}

int AUTone(int freq, int msec)  {
  char tempstr[40];
  sprintf(tempstr,"tones %d %d",msec,freq);
  system(tempstr);
  return 0;
}


/*****f* EyeSim/eyesim_find_file
 *
 * Search for given filename in current directory, directory pointed
 * to by env EYESIM_HOME and in precompiled pathname defined by
 * PKGDATADIR.  The returned string must be free'ed by the caller.
 *****
 */
char *
eyesim_find_file(const char *filename)
{
  char globalfile[1024];
  FILE *fp;
  char *simhome = getenv("EYESIM_HOME");

  if (NULL != (fp = fopen(filename, "r")))
    {
      fclose(fp);
      return strdup(filename);
    }

  if (NULL != simhome)
    {
      snprintf(globalfile, sizeof(globalfile),
               "%s/%s", simhome, filename);
      if (NULL != (fp = fopen(globalfile, "r")))
        {
          fclose(fp);
          return strdup(globalfile);
        }
    }

  snprintf(globalfile, sizeof(globalfile),
           "%s/%s", PKGDATADIR, filename);
  if (NULL != (fp = fopen(globalfile, "r")))
    {
      fclose(fp);
      return strdup(globalfile);
    }
  return NULL;
}
