/*****************************************************************************
 * Functions:                                                                   *
 * IRHandle IRInit(DeviceSemantics)     | Initialise specific IR Handler        *
 * int IRRelease(IRHandle)              | Release specific IR Handler           *
 * int IRRead(IRHandle)                 | Reads in specific IR                  *
 *****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "protos.h"
#include "viewscreen.h"
#include "eyesim.h"

int IRrange, IRcount = 0;


IRHandle IRInit(DeviceSemantics semantics)  {
  int IRsem = -semantics+IR, j = 0, i;
  InitialiseLCD();
  if(robot_count != robot_id.Num_robot)
      ThreadFork();

  //fprintf(stderr, "ir.c: robotindex = %d\n", robotindex());
  display_screen();

  while ((IRsem >= 0) && (j < NumOfIR))  {
    if (IR_Sensor[robotindex()][j] == 0) {

      if(semantics == IRSen[robotindex()][j].semantic)  {

        IR_Sensor[robotindex()][j] = rand()%10 + 201 + 10*IRsem;
        //fprintf(stderr, "ir.c: IRinput[robotindex()]=%s\n", IRinput[robotindex()]);

        if (IRinput[robotindex()] != NULL)
          IRinput[robotindex()][strlen(IRinput[robotindex()])] = '\0';
        else
          {
            /* XXX This crashes, but I do not have time to fix it... :-) */
            assert(NULL != IRinput[robotindex()]);
            IRinput[robotindex()][0] = '\0';
          }


      IRcount++;
      OSSemP(&sf);
      fl_winset(FL_ObjWin(eyesim_view->screenText));
      fl_rectf(eyesim_view->screenText->x+1,eyesim_view->screenText->y+1,
               eyesim_view->screenText->w-2,eyesim_view->screenText->h-2,
               FL_COL1);
      OSSemV(&sf);
      //fprintf(stderr, "ir.c: IRinput[robotindex()]=%d\n", *IRinput[robotindex()] );
      strcpy(IRinput[robotindex()],"IR (");

      for(i=0;i<NumOfIR;i++)
        if(IR_Sensor[robotindex()][i]) {
          strcat(IRinput[robotindex()]," ");
          strcat(IRinput[robotindex()],IRSen[robotindex()][i].name);
        }
      strcat(IRinput[robotindex()]," )");
      eyesim_DoText();

      return IR_Sensor[robotindex()][j];
      }
    }
    j++;
  }
  check_forms_redraw_screen();
  return 0;
}


int IRRelease(IRHandle handle) {
  int i;

  for(i=0; i<NumOfIR; i++)
    if (handle == IR_Sensor[robotindex()][i]) {
      IRcount--;
      IR_Sensor[robotindex()][i] = 0;
      check_forms_redraw_screen();
      return 0;
    }
  fprintf(stderr, "IR not found\n");
  check_forms_redraw_screen();
  return -1;
}

int IRRead(IRHandle handle) {
  int i = 0;

  if (handle == 0) {
    fprintf(stderr, "IR not initialised\n");
    check_forms_redraw_screen();
    return -1;
  }

  while((i < NumOfIR) && (handle != IR_Sensor[robotindex()][i]))
    i++;
  if(i == NumOfIR) {
    fprintf(stderr, "IR not found\n");
    check_forms_redraw_screen();
    return -1;
  }
  check_forms_redraw_screen();
  return IR_detect[robotindex()][i];
}


