/****i* eyesim/nocam.c
 * AUTHOR
 *   Petter Reinholdtsen <pere@td.org.uit.no>
 *
 * DESCRIPTION
 *   Dummy routines that simulates Eyebot color camera but always
 *   return a black image.  It is used to get programs using camera
 *   running without a camera connected.
 *
 ************************************************************************/

#include "eyesim.h" /* for InitialiseLCD() */

int
CAMInit(int zoom)
{
    InitialiseLCD();
    return 0x12; /* Color camera, 0x10 = Quickcam, 0x11 = EyeCam */
}

int
CAMGetFrame(image *buf)
{
  memset(buf, 0, sizeof(*buf)); /* Fill with zero (black) */
  return 0;
}

int
CAMGetColFrame(colimage *buf, int convert)
{
  if (convert)
    return CAMGetFrame((image*)buf);
  memset(buf, 0, sizeof(*buf)); /* Fill with zero (black) */
  return 0;
}

int
CAMSet(int bright, int para1, int para2)
{
  /* Ignore new setting */
  return 0;
}

int
CAMGet(int *bright, int *para1, int *para2)
{
  /* Fake settings */
  *bright = 0;
  *para1  = 0;
  *para2  = 0;
  return 0;
}

int
CAMMode(int mode)
{
  /* Ignore new mode */
  return 0;
}

int
CAMRelease(void)
{
  return 0;
}

void
CAMSIM_addobject(int num_robots)
{
}

void
CAMSIM_removeobject(int num)
{
}

void
CAMSIM_newmap(Segment *wld, int num)
{
}


/*
 * While this function is used and placed in cam3dsim.cc, we need a
 * "dummy" function here as well.  Remove when this is no longer the
 * case.
 */
Window
show_image(Window window, int robotid, BYTE *ibuffer,
           int width, int height,
           int swidth, int sheight,
           int xoff, int yoff,
           int flipped)
{
  return 0;
}
