/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/* Functions:                                                        */
/* int PSD_Setup(int semantics, void* dataarea); | init single PSD   */
/* int PSD_Start(int bitmask, BOOL cycle);       | shoot PSD(s)      */
/* int PSD_Check();                              | check if shot done*/
/* int PSD_Stop();                               | stop cyclic       */
/* int PSD_Release();                            | release ALL PSDs  */
/* int PSD_Get(int handle);                      | get act. distance */
/* int PSD_GetRaw(int handle);                   | get act. raw_value*/
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <forms.h>
#include "viewscreen.h"
#include "protos.h"
#include "eyesim.h"

int startPSD_, endPSD_;
static int lastPSD;
static BOOL cyclePSD;
static BOOL isStarted=FALSE;
static struct timeval cntTime, lastTime;
static int PSDcount = 0;

PSDHandle PSDInit(DeviceSemantics semantics)  {
  int i, j=0;
  int PSDsem = -semantics+PSD;
  InitialiseLCD();
  if(robot_count != robot_id.Num_robot)
      ThreadFork();

  while ((PSDsem >= 0) && (j < NumOfPSD))  {
    if ((PSD_Sensor[robotindex()][j] == 0)
        && (semantics == PSDSen[robotindex()][j].semantic))  {

      PSD_Sensor[robotindex()][j] = rand()%10 + 201 + 10*PSDsem;
      PSDcount++;
        strcpy(PSDinput,"PSD (");
        for(i=0;i<NumOfPSD;i++)
          if(PSD_Sensor[0][i]) {
            strcat(PSDinput," ");
            strcat(PSDinput, PSDSen[0][i].name);
          }
        strcat(PSDinput," )");
        eyesim_DoText();

      return PSD_Sensor[robotindex()][j];
    }
    j++;
  }

  check_forms_redraw_screen();
  return 0;
}

int PSDRelease() {
  int i;

  for(i=0; i<NumOfPSD; i++)
    if(PSD_Sensor[robotindex()][i]) {
      PSD_Sensor[robotindex()][i] = 0;
      PSDcount--;
    }
  check_forms_redraw_screen();
  return 0;
}

int PSDStart(PSDHandle bitmask, BOOL cycle) {
  int i;
  BOOL sim_working = FALSE;
  for(i=0; i<NumOfPSD; i++)
    if(PSD_Sensor[robotindex()][i]!=0)
      sim_working = TRUE;
  if (!sim_working) {
    fprintf(stderr,"No PSD initialised\n");
    return -1;
  }
  cyclePSD = cycle;
  lastTime = cntTime;
  isStarted=TRUE;
  return 0;
}

int PSDStop() {
  isStarted = FALSE;
  return 0;
}

BOOL PSDCheck() {
  int i;
  BOOL sim_working = FALSE;
  for(i=0; i<NumOfPSD; i++)
    if(PSD_Sensor[robotindex()][i]!=0)
      sim_working = TRUE;
  if (!sim_working)
    {
      fprintf(stderr,"No PSD initialised\n");
      return -1;
    }
  if(!isStarted) {
    fprintf(stderr, "No PSD measuring started\n");
    return -1;
  }
  return TRUE;
}


int PSDGet(PSDHandle handle) {
  int i = 0;

  if (handle == 0) {
    fprintf(stderr,"PSD not initialised %ld \n",pthread_self());
    check_forms_redraw_screen();
    return -1;
  }
  while((i<NumOfPSD) && (handle != PSD_Sensor[robotindex()][i]))
    i++;
  if(i == NumOfPSD) {
    fprintf(stderr,"PSD not found %d - %d\n", handle, OSMachineID());
    check_forms_redraw_screen();
    return -1;
  }
  if(!isStarted) {
    fprintf(stderr, "No PSD measuring started\n");
    return -1;
  }
  gettimeofday(&cntTime, NULL);
  if(cyclePSD)
    {
      lastPSD = PSD_detect[robotindex()][i];
      if(lastPSD < 0)
        lastPSD = 0;
      else if(lastPSD>=1000)
        lastPSD = PSD_OUT_OF_RANGE;
      lastTime = cntTime;
    }
  else if((cntTime.tv_sec - lastTime.tv_sec) > 0
          || (cntTime.tv_usec - lastTime.tv_usec) > 60000)
    {
      lastPSD = PSD_detect[robotindex()][i];
      lastTime = cntTime;
    }
  check_forms_redraw_screen();
  return lastPSD;
}

int
PSDGetRaw(PSDHandle handle)
{
  return PSDGet(handle);
}

