/****i* eyesim/radio.c
 * AUTHOR
 *   Petter Reinholdtsen <pere@td.org.uit.no>
 * DESCRIPTION
 *   RoBIOS radio functions for use by the Eyebot simulator.
 * NOTE
 *   Currently, these are only dummy replacement functios to make the
 *   linker happy.  Message tranfer always fails, and there are never
 *   messages to be received.
 * COPYRIGHT
 *   GNU Public License
 *****/

#include <stdio.h>
#include "types.h"
#include "eyesim.h"
#include "debugprint.h"

int
RADIOInit (void)
{
  STUB();
  return 0;
}

int
RADIOCheck (void)
{
  static int firsttime = 1;
  if (firsttime)
    {
      STUB();
      firsttime = 0;
    }
  /* There are never messages waiting */
  return 0;
}

int
RADIORecv (BYTE* id, int* bytesReceived, BYTE* buffer)
{
  STUB();
  /* Receiving always fails */
  return -1;
}

int
RADIOSend (BYTE id, int byteCount, BYTE* buffer)
{
  static int firsttime = 1;
  if (firsttime)
    {
      STUB();
      firsttime = 0;
    }
  /* Sending always fails */
  return -1;
}

int
RADIOTerm (void)
{
  STUB();
  return 0;
}

int
RADIOGetIoctl(RadioIOParameters* radioParams)
{
  STUB();
  return -1;
}

int
RADIOSetIoctl(RadioIOParameters radioParams)
{
  STUB();
  return -1;
}

int
RADIOGetStatus (RadioStatus *s)
{
  int i;
  STUB();
  s->master = 0; /* There are no one active, the radio is dead */
  for (i = 0; i < MAXEYE; i++)
    s->active[i] = FALSE;
  return -1;
}
