#include "types.h"
#include "debugprint.h"
#include "eyesim.h"
#include "protos.h"

int     serspeeds[] = {9600,19200,38400,57600,115200};

/* Buffer one line before printing it. */
static char buf[1024];
static unsigned int bufpos = 0;

int
OSInitRS232 (int baudrate, int handshake, int face)
{
  STUB();
  return 0;
}

int OSCheckInRS232 (int face)
{
  STUB();
  return 0;
}

int OSCheckOutRS232 (int face)
{
  STUB();
  return 0;
}

int OSFlushInRS232 (int face)
{
  STUB();
  return 0;
}

int OSFlushOutRS232 (int face)
{
  buf[bufpos] = 0;
  fprintf(stderr, "RS232: \"%s\"\n", buf);
  bufpos = 0;

  return 0;
}

int
OSSendCharRS232(const char ch, const int face)
{
  if ('\n' == ch || bufpos >= sizeof(buf))
    OSFlushOutRS232(face);
  else
    buf[bufpos++] = ch;
  return 0;
}

int
OSSendRS232(const char *ch, const int face)
{
  OSSendCharRS232(*ch, face);
  return 0;
}

int
OSRecvRS232 (char *chara, int face)
{
  STUB();
  return -1;
}
