#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "forms.h"
#include "eyesim.h"
#include "protos.h"

#define SQR(x) (x * x)

Point GetIntersect(Segment, Segment, int *);
int IsBetween(long, long, long);
int IsBetweenPoints(Segment, Segment, Point *);
Segment linePSD[MAX_ROBOTS][MaxNumOfPSD], lineIR[MAX_ROBOTS][MaxNumOfIR];

XSegment *Filter(int *NSegVisible) {
  int i, j, k;
  int cnt, IRcnt;
  int tmpPSD;
  int isvisible = 0;
  int NumSeg = 0;
  Segment *wld;

  Point tmp1, tmp2, t1;
  Segment robotSide[4][MAX_ROBOTS];
  Segment *WinSeg;
  XSegment *visible = NULL;

  *NSegVisible = 0;

  WinSeg = (Segment *)malloc(4*sizeof(Segment));
  WinSeg[0].x1 = (long)(cState.map.x);
  WinSeg[0].y1 = (long)(cState.map.y);
  WinSeg[0].x2 = (long)(cState.map.x + (cState.w*cState.zoom));
  WinSeg[0].y2 = WinSeg[0].y1;
  WinSeg[1].x1 = WinSeg[0].x2;
  WinSeg[1].y1 = WinSeg[0].y2;
  WinSeg[1].x2 = WinSeg[0].x2;
  WinSeg[1].y2 = (long)(cState.map.y + (cState.h*cState.zoom));
  WinSeg[2].x1 = WinSeg[0].x1;
  WinSeg[2].y1 = WinSeg[1].y2;
  WinSeg[2].x2 = WinSeg[0].x2;
  WinSeg[2].y2 = WinSeg[1].y2;
  WinSeg[3].x1 = WinSeg[0].x1;
  WinSeg[3].y1 = WinSeg[0].y1;
  WinSeg[3].x2 = WinSeg[0].x1;
  WinSeg[3].y2 = WinSeg[1].y2;

  for (i=0; i<robot_count; i++)
  {
    vw_robots[i].stalled = FALSE;
  robotSide[0][i].x1 =robot[i].x+1.1*ROBOT_RADIUS*cos(robot[i].radians);
  robotSide[0][i].y1 =robot[i].y-1.1*ROBOT_RADIUS*sin(robot[i].radians);
  robotSide[0][i].x2 =robot[i].x+1.15*ROBOT_RADIUS*cos(robot[i].radians+1.2);
  robotSide[0][i].y2 =robot[i].y-1.15*ROBOT_RADIUS*sin(robot[i].radians+1.2);
  robotSide[1][i].x1=robot[i].x+1.1*ROBOT_RADIUS*cos(robot[i].radians);
  robotSide[1][i].y1=robot[i].y-1.1*ROBOT_RADIUS*sin(robot[i].radians);
  robotSide[1][i].x2=robot[i].x+1.15*ROBOT_RADIUS*cos(robot[i].radians-1.2);
  robotSide[1][i].y2=robot[i].y-1.15*ROBOT_RADIUS*sin(robot[i].radians-1.2);
  robotSide[2][i].x1 =robot[i].x+1.1*ROBOT_RADIUS*cos(M_PI+robot[i].radians);
  robotSide[2][i].y1 =robot[i].y-1.1*ROBOT_RADIUS*sin(M_PI+robot[i].radians);
  robotSide[2][i].x2 =robot[i].x+1.15*ROBOT_RADIUS*cos(M_PI+robot[i].radians-1.2);
  robotSide[2][i].y2 =robot[i].y-1.15*ROBOT_RADIUS*sin(M_PI+robot[i].radians-1.2);
  robotSide[3][i].x1=robot[i].x+1.1*ROBOT_RADIUS*cos(M_PI+robot[i].radians);
  robotSide[3][i].y1=robot[i].y-1.1*ROBOT_RADIUS*sin(M_PI+robot[i].radians);
  robotSide[3][i].x2=robot[i].x+1.15*ROBOT_RADIUS*cos(M_PI+robot[i].radians+1.2);
  robotSide[3][i].y2=robot[i].y-1.15*ROBOT_RADIUS*sin(M_PI+robot[i].radians+1.2);
  for(cnt=0; cnt<NumOfPSD; cnt++) {
    if(PSD_Sensor[i][cnt]) {
      linePSD[i][cnt].x1 = robot[i].x+(PSDSen[i][cnt].d+startPSD_)*cos(robot[i].radians+PSDSen[i][cnt].t);
      linePSD[i][cnt].y1 = robot[i].y-(PSDSen[i][cnt].d+startPSD_)*sin(robot[i].radians+PSDSen[i][cnt].t);
      linePSD[i][cnt].x2 = linePSD[i][cnt].x1+endPSD_*cos(robot[i].radians+PSDSen[i][cnt].t+PSDSen[i][cnt].a);
      linePSD[i][cnt].y2 = linePSD[i][cnt].y1-endPSD_*sin(robot[i].radians+PSDSen[i][cnt].t+PSDSen[i][cnt].a);
      PSD_detect[i][cnt] = startPSD_ + endPSD_;
    }
  }

  for(cnt=0; cnt<NumOfIR; cnt++) {
    if (IR_Sensor[i][cnt]) {
      lineIR[i][cnt].x1 = robot[i].x+IRSen[i][cnt].d*cos(robot[i].radians+IRSen[i][cnt].t);
      lineIR[i][cnt].y1 = robot[i].y-IRSen[i][cnt].d*sin(robot[i].radians+IRSen[i][cnt].t);
      lineIR[i][cnt].x2 = (int)((float)lineIR[i][cnt].x1+((float)IRrange*cos(robot[i].radians+ \
                        IRSen[i][cnt].t+IRSen[i][cnt].a)*(1.0+(float)err_ir*((float)(rand()%200)-90.01)/100.1)));
      lineIR[i][cnt].y2 = (int)((float)lineIR[i][cnt].y1-((float)IRrange*sin(robot[i].radians+ \
                        IRSen[i][cnt].t+IRSen[i][cnt].a)*(1.0+(float)err_ir*((float)(rand()%200)-90.01)/100.1)));
      IR_detect[i][cnt] = 1;
    }
  }
  } /* end of for loop */


  i = 0; /* *** needs fix *** */
  cnt = 0;
  wld = get_current_map(&NumSeg);
  while ((cnt < NumSeg) && (wld[cnt].x1 < (cState.map.x+(cState.w*cState.zoom)))) {
    if(IsBetweenPoints(wld[cnt],WinSeg[3],&tmp1))  {
      if(IsBetweenPoints(wld[cnt],WinSeg[0],&tmp2));
      else if(IsBetweenPoints(wld[cnt],WinSeg[1],&tmp2));
      else if(IsBetweenPoints(wld[cnt],WinSeg[2],&tmp2));
      else {
        tmp2.x = wld[cnt].x2;
        tmp2.y = wld[cnt].y2;
      }
    } else if(IsBetweenPoints(wld[cnt],WinSeg[0],&tmp1))  {
      if(IsBetweenPoints(wld[cnt],WinSeg[1],&tmp2));
      else if(IsBetweenPoints(wld[cnt],WinSeg[2],&tmp2));
      else {
        if(wld[cnt].y2 > cState.map.y) {
          tmp2.x = wld[cnt].x2;
          tmp2.y = wld[cnt].y2;
        } else {
          tmp2.x = wld[cnt].x1;
          tmp2.y = wld[cnt].y1;
        }
      }
    } else if(IsBetweenPoints(wld[cnt],WinSeg[2],&tmp1))  {
      if(IsBetweenPoints(wld[cnt],WinSeg[1],&tmp2));
      else if(IsBetweenPoints(wld[cnt],WinSeg[0],&tmp2));
      else {
        if(wld[cnt].y2 < (cState.map.y + (cState.h*cState.zoom))) {
          tmp2.x = wld[cnt].x2;
          tmp2.y = wld[cnt].y2;
        } else {
          tmp2.x = wld[cnt].x1;
          tmp2.y = wld[cnt].y1;
        }
      }
    } else if(IsBetweenPoints(wld[cnt],WinSeg[1],&tmp2))  {
      tmp1.x = wld[cnt].x1;
      tmp1.y = wld[cnt].y1;
    } else if((wld[cnt].x1 > cState.map.x) && (wld[cnt].x1 < ((cState.w*cState.zoom) + cState.map.x))) {
      if((wld[cnt].y1 > cState.map.y) && (wld[cnt].y1 < ((cState.h*cState.zoom) + cState.map.y))) {
        tmp1.x = wld[cnt].x1;
        tmp1.y = wld[cnt].y1;
        tmp2.x = wld[cnt].x2;
        tmp2.y = wld[cnt].y2;
      } else
        isvisible = 0;
    } else
      isvisible = 0;

   for(i=0; i < robot_count; i++)
    for (IRcnt=0; IRcnt<NumOfPSD; IRcnt++)
      if(PSD_Sensor[i][IRcnt])
        if(IsBetweenPoints(wld[cnt], linePSD[i][IRcnt], &t1)) {
          tmpPSD = sqrt(eyesim_sqr(t1.x-linePSD[i][IRcnt].x1)+eyesim_sqr(t1.y-linePSD[i][IRcnt].y1));
          if(tmpPSD < PSD_detect[i][IRcnt])
            PSD_detect[i][IRcnt] = tmpPSD;
        }
   for(i=0; i < robot_count; i++)
    for (IRcnt=0; IRcnt<NumOfIR; IRcnt++)
      if (IR_Sensor[i][IRcnt] != 0)
        if((IR_detect[i][IRcnt]==1)&&(IsBetweenPoints(wld[cnt], lineIR[i][IRcnt], &t1)))
          IR_detect[i][IRcnt] = 0;

    if (isvisible)  {
      if (*NSegVisible)
        visible = (XSegment *)realloc(visible, (*NSegVisible+1)*sizeof(XSegment));
      else
        visible = (XSegment *)malloc(sizeof(XSegment));

      for (i=0; i<robot_count; i++)
      {
       if(!vw_robots[i].stalled)  {
         vw_robots[i].stalled = TRUE;
        if(IsBetweenPoints(wld[cnt],robotSide[0][i],&t1)) {
          if(vw_robots[i].hiddenhandle)
            if(vw_robots[i].speed.v <= 0)
              vw_robots[i].stalled = FALSE;
        } else if(IsBetweenPoints(wld[cnt],robotSide[1][i],&t1)) {
          if(vw_robots[i].hiddenhandle)
            if(vw_robots[i].speed.v <= 0)
              vw_robots[i].stalled = FALSE;
        } else if(IsBetweenPoints(wld[cnt],robotSide[2][i],&t1)) {
          if(vw_robots[i].hiddenhandle)
            if(vw_robots[i].speed.v >= 0)
              vw_robots[i].stalled = FALSE;
        } else if(IsBetweenPoints(wld[cnt],robotSide[3][i],&t1))  {
          if(vw_robots[i].hiddenhandle)
            if(vw_robots[i].speed.v >= 0)
              vw_robots[i].stalled = FALSE;
        } else
          vw_robots[i].stalled = FALSE;

        if(vw_robots[i].stalled)  {
          bumperAngle[i] = atan((float)(t1.x) - (float)robot[i].y)/abs(((float)robot[i].x-(float)(t1.y)));
          if(t1.x < robot[i].x)
            bumperAngle[i] = M_PI - bumperAngle[i];
        }
       }
      } /* end for robots */
      visible[*NSegVisible].x1 = (short)(((tmp1.x-cState.map.x)/cState.zoom)+cState.x);
      visible[*NSegVisible].y1 = (short)(((tmp1.y-cState.map.y)/cState.zoom)+cState.y);
      visible[*NSegVisible].x2 = (short)(((tmp2.x-cState.map.x)/cState.zoom)+cState.x);
      visible[*NSegVisible].y2 = (short)(((tmp2.y-cState.map.y)/cState.zoom)+cState.y);
      (*NSegVisible)++;
    }
    cnt++;
    isvisible = 1;
  }
  for(i=0; i<robot_count; i++)
    for(k=0;k<robot_count;k++)  {
      if((i!=k) && (NO_THREAD != robot_id.index[i]))
      for(j=0;j<4;j++)  {
        if(IsBetweenPoints(robotSide[0][i],robotSide[j][k], &t1)) {
          if(vw_robots[i].speed.v > 0)
            vw_robots[i].stalled = TRUE;
          bumperAngle[i] = atan((float)(t1.x) - (float)robot[i].y)/abs(((float)robot[i].x-(float)(t1.y)));
          if(t1.x < robot[i].x)
            bumperAngle[i] = M_PI - bumperAngle[i];
        } else if(IsBetweenPoints(robotSide[1][i],robotSide[j][k], &t1)) {
          if(vw_robots[i].speed.v > 0)
            vw_robots[i].stalled = TRUE;
          bumperAngle[i] = atan((float)(t1.x) - (float)robot[i].y)/abs(((float)robot[i].x-(float)(t1.y)));
          if(t1.x < robot[i].x)
            bumperAngle[i] = M_PI - bumperAngle[i];
        } else if(IsBetweenPoints(robotSide[2][i],robotSide[j][k], &t1)) {
          if(vw_robots[i].speed.v < 0)
            vw_robots[i].stalled = TRUE;
          bumperAngle[i] = atan((float)(t1.x) - (float)robot[i].y)/abs(((float)robot[i].x-(float)(t1.y)));
          if(t1.x < robot[i].x)
            bumperAngle[i] = M_PI - bumperAngle[i];
        } else if(IsBetweenPoints(robotSide[3][i],robotSide[j][k], &t1)) {
          if(vw_robots[i].speed.v < 0)
            vw_robots[i].stalled = TRUE;
          bumperAngle[i] = atan((float)(t1.x) - (float)robot[i].y)/abs(((float)robot[i].x-(float)(t1.y)));
          if(t1.x < robot[i].x)
            bumperAngle[i] = M_PI - bumperAngle[i];
        }
      }
  }

  for(i=0;i<robot_count;i++)
    for(j=0;j<robot_count;j++)  {
      if((i != j) && (NO_THREAD != robot_id.index[i]))
        for(k=0;k<4;k++)
          for(IRcnt=0; IRcnt < NumOfPSD; IRcnt++)
            if(PSD_Sensor[i][IRcnt])
              if(IsBetweenPoints(robotSide[k][j], linePSD[i][IRcnt], &t1)) {
                tmpPSD = sqrt(eyesim_sqr(t1.x-linePSD[i][IRcnt].x1)+eyesim_sqr(t1.y-linePSD[i][IRcnt].y1));
              if(tmpPSD < PSD_detect[i][IRcnt])
                PSD_detect[i][IRcnt] = tmpPSD;
        }
  }

  for(i=0;i<robot_count;i++)
    for(j=0;j<robot_count;j++)  {
      if((i != j) && (NO_THREAD != robot_id.index[i]))
        for(k=0;k<4;k++)
          for (IRcnt=0; IRcnt<NumOfIR; IRcnt++)
            if (IR_Sensor[i][IRcnt] != 0)
              if((IR_detect[i][IRcnt]==1)&&(IsBetweenPoints(robotSide[k][j],
                lineIR[i][IRcnt], &t1)))
                IR_detect[i][IRcnt] = 0;
  }

  i = 0; /* *** needs fix *** */
  if(dbg) {
    for(IRcnt=0; IRcnt<NumOfPSD; IRcnt++)
      if(PSD_Sensor[i][IRcnt])
        fprintf(stderr, "%s ", PSDSen[i][IRcnt].name);
    fprintf(stderr, ":");
    for(IRcnt=0; IRcnt<NumOfPSD; IRcnt++)
      if (PSD_Sensor[i][IRcnt])
        fprintf(stderr, "%d ", PSD_detect[i][IRcnt]);
    fprintf(stderr,"\n");
    for(IRcnt=0; IRcnt<NumOfIR; IRcnt++)
      if(IR_Sensor[i][IRcnt])
        fprintf(stderr, "%s ", IRSen[i][IRcnt].name);
    fprintf(stderr, ":");
    for(IRcnt=0; IRcnt<NumOfIR; IRcnt++)
      if (IR_Sensor[i][IRcnt])
        fprintf(stderr, "%d ", IR_detect[i][IRcnt]);
    fprintf(stderr,"\n");
  }
  if(dbg)
  fprintf(stderr,"bump=%f\n",bumperAngle[i]);

  for (i=0; i<robot_count; i++)
  for(IRcnt=0; IRcnt<NumOfPSD; IRcnt++)  {
    PSD_detect[i][IRcnt] *= (1.0 + (float)err_psd*((float)(rand() % 201) -100)/100.1);
    if(PSD_detect[i][IRcnt] > 999)
      PSD_detect[i][IRcnt] = 999;
    else if(PSD_detect[i][IRcnt] < 0)
      PSD_detect[i][IRcnt] = 0;
  }

  free(WinSeg);
  return visible;
}


Point GetIntersect(Segment one, Segment two, int *undef)  {
  Point P;
  float m1, m2, b1, b2;

  if ((one.x1 == one.x2) && (two.x1 == two.x2)) {
    *undef = 1;
    return P;
  } else {
    *undef = 0;
    if (one.x1 == one.x2) {
      m2 = ((float)two.y2 - (float)two.y1) / ((float)two.x2 - (float)two.x1);
      b2 = (float)two.y2 - m2 * (float)two.x2;
      P.x = (long)one.x1;
      P.y = (long)(m2*one.x1+b2);
    } else if (two.x1 == two.x2) {
      m1 = ((float)one.y2 - (float)one.y1) / ((float)one.x2 - (float)one.x1);
      b1 = (float)one.y2 - (m1 * (float)one.x2);
      P.x = (long)two.x1;
      P.y = (long)((m1*two.x1)+b1);
    } else {
      m1 = ((float)one.y2 - (float)one.y1) / ((float)one.x2 - (float)one.x1);
      b1 = (float)one.y2 - m1  * (float)one.x2;
      m2 = ((float)two.y2 - (float)two.y1) / ((float)two.x2 - (float)two.x1);
      b2 = (float)two.y2 - m2 * (float)two.x2;
      if(m1 == m2) {
        *undef = 1;
        return P;
      }
      P.x = (long)((b1 - b2) / (m2 - m1));
      P.y = (long)((m2 * b1 - m1 * b2) / (m2 - m1));
      P.theta = 0;
    }
  }
  return P;
}

int IsBetween(long a, long b, long c)  {
  if ((a <= (b + 1)) && (a >= (c - 1)))
    return 1;
  else if ((a >= (b - 1)) && (a <= (c + 1)))
    return 1;
  return 0;
}

int IsBetweenPoints(Segment data, Segment target, Point *intPoint)  {
  int undef = 1;

  *intPoint = GetIntersect(data, target, &undef);
  if (undef)
    return 0;

  if (IsBetween(intPoint->x,target.x1, target.x2) && \
                 IsBetween(intPoint->y, target.y1, target.y2))
  if (IsBetween(intPoint->x,data.x1, data.x2) && \
                 IsBetween(intPoint->y, data.y1, data.y2))
    return 1;
  return 0;
}

