/****i* eyesim/servo.c
 * AUTHOR
 *   Petter Reinholdtsen <pere@td.org.uit.no>
 * DESCRIPTION
 *   RoBIOS servo functions for use by the Eyebot simulator.
 * NOTE
 *   Currently, these are only dummy replacement functios to make the
 *   linker happy.  Nothing is done when the servo angle is changed.
 * COPYRIGHT
 *   GNU Public License
 *****/

#include <stdio.h>
#include "hdt.h"
#include "eyesim.h"
#include "debugprint.h"

#define HANDLE_START 0xABBA
#define WRONG_HANDLE 0xFF00

ServoHandle
SERVOInit (DeviceSemantics semantics)
{
  STUB();
  return HANDLE_START;
}

int
SERVORelease (ServoHandle handle)
{
  STUB();
  if (HANDLE_START != handle)
    return WRONG_HANDLE;
  return 0;
}

int
SERVOSet (ServoHandle handle,int angle)
{
  static int firsttime = 1;
  if (firsttime)
    {
      STUB();
      firsttime = 0;
    }
  return 0;
}
