/*
| ----------------------------------------------------------------------------
| Filename: timer.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (k_schmit@informatik.uni-kl.de)
| Description:
| timer routines
------------------------------------------------------------------------------
| Functions:
| int OSSetTime(int,int,int);                   | set time
| int OSGetTime(int *,int *,int *,int *);       | read time
| int OSShowTime(void);                         | display time
| int OSGetCount(void);                         | get system counter value
|
------------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/time.h>
#include <unistd.h>
#include <time.h>
#include <forms.h>
#include "protos.h"
#include "eyesim.h"

time_t timeInit = 0;
struct timeval timePast[MAX_ROBOTS];

/*-------------------------------------------------------------------- */

/* Clock Routines */
/* -------------- */

/* return system counter value */
int OSGetCount(void)
{
  struct timeval nowtime;
  gettimeofday(&nowtime, NULL);

  check_forms_redraw_screen();

  return nowtime.tv_sec * 100 + nowtime.tv_usec / 10000
    - timePast[robotindex()].tv_sec * 100
    - timePast[robotindex()].tv_usec / 10000;
}

/* set_time - Set the real time clock to a specific time. */
int OSSetTime(int hrs,int mins,int secs)
{
    struct tm timeBroke;

    timeBroke.tm_sec = secs;
    timeBroke.tm_min = mins;
    timeBroke.tm_hour = hrs;
    timeBroke.tm_mday = 1;
    timeBroke.tm_mon = 1;
    timeBroke.tm_year = 1970;
    timeBroke.tm_wday = 1;
    timeBroke.tm_yday = 1;
    timeInit = mktime(&timeBroke);
    gettimeofday(&timePast[robotindex()], NULL);
    check_forms_redraw_screen();
    return 0;
}

/* get_time - Returns timer values. */
int OSGetTime(int *hrs,int *mins,int *secs,int *ticks)
{
  struct timeval nowtime;
  struct tm *timeBroke;
  time_t timeCalc;

  gettimeofday(&nowtime, NULL);
  timeCalc = timeInit + (nowtime.tv_sec - timePast[robotindex()].tv_sec);
  timeBroke = (gmtime(&timeCalc));
  *hrs = timeBroke->tm_hour;
  *mins = timeBroke->tm_min;
  *secs = timeBroke->tm_sec;
  *ticks = (nowtime.tv_usec - timePast[robotindex()].tv_usec)/10000;
  if (0 > *ticks)
    {
      *secs -= 1;
      *ticks += 100;
    }
  check_forms_redraw_screen();
  return 0;
}

int OSShowTime()
{
  int hrs, mins, secs, ticks;
  OSGetTime(&hrs, &mins, &secs, &ticks);
  LCDPrintf("The time is:\n%2d%2d%2d\n", hrs, mins, secs, ticks);
  check_forms_redraw_screen();
  return 0;
}

int OSWait(int n)  {
  struct timeval t, waitSec, nowtime;
  struct timezone z;

  gettimeofday(&t,&z);
  waitSec.tv_sec = n / 100 + t.tv_sec;
  waitSec.tv_usec = (n *10000) + t.tv_usec;
  if(waitSec.tv_usec >= 1000000)  {
    waitSec.tv_sec++;
    waitSec.tv_usec = waitSec.tv_usec % 1000000;
  }
  do {
    gettimeofday(&nowtime,&z);

    check_forms_redraw_screen();
  } while((nowtime.tv_sec<=(waitSec.tv_sec+1)) && ((nowtime.tv_sec<waitSec.tv_sec)||(nowtime.tv_usec<waitSec.tv_usec)));
  // || (nowtime.millitm < waitMilli))  {
  return 0;
}
