
/*      $Id: viewscreen.c,v 1.9 2000/08/03 10:28:59 pere Exp $         */

#include "forms.h"
#include <stdlib.h>
#include "viewscreen.h"
#include "protos.h"
#include "eyesim.h"
#include "debugprint.h"

FD_viewscreen *eyesim_create_form_viewscreen(void)
{
  FL_OBJECT *obj;
  FD_viewscreen *fdui = (FD_viewscreen *) fl_calloc(1, sizeof(*fdui));

  OSSemP(&sf);
  fdui->viewscreen = fl_bgn_form(FL_NO_BOX, 495, 540);
  obj = fl_add_box(FL_UP_BOX,0,0,495,540,"");
  obj = fl_add_menu(FL_PULLDOWN_MENU,10,10,60,30,"File");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_menu(obj,"World...      Ctrl W|Maze...       Ctrl M|Param...     Ctrl P|Change parameters|Exit...        Ctrl Q");
    fl_set_button_shortcut(obj,"fF^F",1);
    fl_set_object_callback(obj,eyesim_menuFILE,0);
  obj = fl_add_menu(FL_PULLDOWN_MENU,70,10,70,30,"Robots");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_menu(obj,"Add New  |Delete   |See Trail|Hide Trail");
    fl_set_button_shortcut(obj,"fF^F",1);
    fl_set_object_callback(obj,eyesim_menuGROW,0);
  obj = fl_add_menu(FL_PULLDOWN_MENU,140,10,70,30,"Zoom");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_menu(obj,"Zoom In ...   Ctrl Z|Zoom Out...   Ctrl U|Zoom Out Full");
    fl_set_button_shortcut(obj,"fF^F",1);
    fl_set_object_callback(obj,eyesim_menuSHRINK,0);
  fdui->Center = obj = fl_add_button(FL_NORMAL_BUTTON,210,10,70,30,"Center");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_button_shortcut(obj,"cC^C",1);
    fl_set_object_callback(obj,eyesim_menuCENTER,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,280,10,70,30,"Refresh");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,eyesim_B_Refresh,0);
  fdui->Pause = obj = fl_add_lightbutton(FL_PUSH_BUTTON,355,10,70,30,"Pause");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_color(obj,FL_YELLOW,FL_RIGHT_BCOL);
    fl_set_object_callback(obj,eyesim_B_Pause,0);
  fdui->Help = obj = fl_add_button(FL_NORMAL_BUTTON,435,10,50,30,"Help");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_button_shortcut(obj,"?",1);
    fl_set_object_callback(obj,eyesim_B_Help,0);

  obj = fl_add_frame(FL_ENGRAVED_FRAME,20,440,455,90,"");
  fdui->screenText = obj = fl_add_text(FL_NORMAL_TEXT,20,440,450,70,"");
  fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->dataText = obj = fl_add_text(FL_NORMAL_TEXT,269,440,200,70,"");
  fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fdui->errorText = obj = fl_add_text(FL_NORMAL_TEXT,22,505,450,20,"Robot has hit OBSTACLE !!!");
  fl_set_object_lalign(obj,FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
  fl_set_object_lcol(obj,FL_COL1);
  obj = fl_add_frame(FL_DOWN_FRAME,20,70,455,360,"");

  fdui->screen = obj = fl_add_free(FL_ALL_FREE,20,70,455,360,"",eyesim_ViewscreenHandler);

  fl_end_form();

  fdui->viewscreen->fdui = fdui;
  OSSemV(&sf);

  return fdui;
}

void
check_forms(void)
{
  InitialiseLCD();
  OSSemP(&sf);
  fl_check_forms();
  OSSemV(&sf);
}

void
check_forms_redraw_screen(void)
{
  InitialiseLCD();
  OSSemP(&sf);
  fl_check_forms();
  fl_redraw_object(eyesim_view->screen);
  OSSemV(&sf);
}

void
display_screen(void)
{
  InitialiseLCD();
  OSSemP(&sf);
  if(!fl_form_is_visible(eyesim_view->viewscreen))
    fl_show_form(eyesim_view->viewscreen, FL_PLACE_FREE, FL_FULLBORDER, "View");
  OSSemV(&sf);
}

void
redraw_screen(void)
{
  InitialiseLCD();
  OSSemP(&sf);
  fl_redraw_object(eyesim_view->screen);
  OSSemV(&sf);
}
