/*
| -----------------------------------------------------------------------------
| Filename: hdttest.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
|               Thomas Braunl   (braunl@ee.uwa.edu.au)
| Description: 
| -------
| HDT data for TEST
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1             /* User specific version nr. just for information */
#define NAME "Test"           /* Unique name of the platform max. 10 chars, just for information */
#define ID   3                  /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                                         60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                                         76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                                        103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                                        134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                                        195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                                        340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                                        830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                                        999, 999, 999, 999, 999, 999, 999, 999};

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

motor_type motor0 = {2,  0, TIMER2, 8191, (void*)(OutBase+2), 6, 7, (BYTE*)&motconv0};
motor_type motor1 = {2,  1, TIMER2, 8191, (void*)(OutBase+2), 4, 5, (BYTE*)0};

quad_type decoder0 = {0, 3, 2, MOTOR_LEFT, 1234, 2.34};
quad_type decoder1 = {0, 4, 5, MOTOR_RIGHT, 1345, 2.34};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 19.56}};

/* Timer2, 20ms period, 0.7ms min, 1.7ms max */
servo_type servo0 = {2,  0, TIMER2, 20000, 700, 1700};
servo_type servo1 = {2,  1, TIMER2, 20000, 700, 1700};
servo_type servo2 = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo3 = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo4 = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo5 = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo6 = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7 = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8 = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9 = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2,  10, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2,  11, TIMER2, 20000, 700, 1700};

bump_type bumper0 = {0, 6, TIMER2, EITHER};
bump_type bumper1 = {0, 7, TIMER2, EITHER};

ir_type   ir0 = {0, 8};
ir_type   ir1 = {0, 9};
ir_type   ir2 = {0, 10};
ir_type   ir3 = {0, 11};
ir_type   ir4 = {0, 12};
ir_type   ir5 = {0, 13};

psd_type   psd0   = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 0, AH, (short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)(Ser1Base+6), 5, AL, (BYTE*)(Ser1Base+4), 0, AL, (short*)&dist0};

info_type roboinfo0  = {0,VEHICLE,SER57600,RTSCTS,SERIAL2,0,OFF,NOAUTOBRIGHTNESS,BATTERY_ON,16,VERSION,NAME,ID};
info_type roboinfo1  = {0,PLATFORM,SER57600,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,16,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
waitstate_type waitstates = {0,3,0,1,0,2};
/* 21MHz - 41Mhz */
/* waitstate_type waitstates = {0,3,1,2,1,2}; */

/* this is a test HDT structure which contains ALL hardware devices     */
/* of all eybot robots currently available                              */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD, QUAD_LEFT,"LEFT",(void *)&decoder0},
    {QUAD, QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {VW,VW,"Drive",(void *)&drive},

    {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0},
    {BUMP, BUMP_RIGHT,"RIGHT",(void *)&bumper1},

    {IR, IR_LF,"LF",(void *)&ir0},
    {IR, IR_LM,"LM",(void *)&ir1},
    {IR, IR_LB,"LB",(void *)&ir2},
    {IR, IR_RF,"RF",(void *)&ir3},
    {IR, IR_RM,"RM",(void *)&ir4},
    {IR, IR_RB,"RB",(void *)&ir5},

    {SERVO,SERVO0, "SERV00",(void *)&servo0},
    {SERVO,SERVO1, "SERV01",(void *)&servo1},
    {SERVO,SERVO2, "SERV02",(void *)&servo2},
    {SERVO,SERVO3, "SERV03",(void *)&servo3},
    {SERVO,SERVO4, "SERV04",(void *)&servo4},
    {SERVO,SERVO5, "SERV05",(void *)&servo5},
    {SERVO,SERVO6, "SERV06",(void *)&servo6},
    {SERVO,SERVO7, "SERV07",(void *)&servo7},
    {SERVO,SERVO8, "SERV08",(void *)&servo8},
    {SERVO,SERVO9, "SERV09",(void *)&servo9},
    {SERVO,SERVO10,"SERV10",(void *)&servo10},
    {SERVO,SERVO11,"SERV11",(void *)&servo11},

    {PSD,PSD_FRONT,"FRONT",(void *)&psd1},
    {PSD,PSD_TEST,"TEST",(void *)&psd0},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo1},

     {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};


