/*
| ------------------------------------------------------------------------------
| Filename: hdtbiped.c
|
| Author:       Thomas Braunl  (braunl@ee.uwa.edu.au)
|
| Description: 
| -------
| HDT data for biped walker 
| ------------------------------------------------------------------------------
*/

#define VERSION 1.6             /* User specific version nr. just for inform. */
#define NAME "Jack"             /* Unique platform name max. 10 chars,inform. */
#define ID   22                 /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"


/* Timer2, 20ms period, 0.7ms min, 1.7ms max */
servo_type _RHipT_ = {2,  0, TIMER2, 20000, 1262, 1818};   
servo_type _RHipB_ = {2,  1, TIMER2, 20000, 727,  2377};    
servo_type _RKnee_ = {2,  2, TIMER2, 20000, 760,  2460};    
servo_type _Torso_ = {2,  4, TIMER2, 20000, 1281, 1847};   
servo_type _RArm_  = {2,  8, TIMER2, 20000, 1042, 2364};   
servo_type _LHipT_ = {2,  9, TIMER2, 20000, 1470, 1826};  
servo_type _LArm_  = {2, 10, TIMER2, 20000, 1042, 2364};   
servo_type _LKnee_ = {2, 12, TIMER2, 20000, 807,  2507};   
servo_type _LHipB_ = {2, 13, TIMER2, 20000, 807,  2507};   


info_type roboinfo = {0,WALKER,SER115200,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for six legged walker */

HDT_entry_type HDT[] =
{
    {SERVO,SERVO0,  "RHipT", (void *)&_RHipT_},
    {SERVO,SERVO1,  "RHipB", (void *)&_RHipB_},
    {SERVO,SERVO2,  "RKnee", (void *)&_RKnee_},

    {SERVO,SERVO4,  "Torso", (void *)&_Torso_},
    {SERVO,SERVO8,  "RArm",  (void *)&_RArm_},
    {SERVO,SERVO10, "LArm",  (void *)&_LArm_},

    {SERVO,SERVO12, "LKnee", (void *)&_LKnee_},
    {SERVO,SERVO13, "LHipB", (void *)&_LHipB_},
    {SERVO,SERVO9,  "LHipT", (void *)&_LHipT_},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

