/* global memory layout 					*/
/* ATTENTION: const.h contains the same constants for C usage 	*/

MemoryStart     =       0x00000000              | should be $0 normally

MinRomSize      =       0x00020000              | 128kB (Size of Flashspace reserved for ROBIOS)

/* ---------------------------- */

HDTSize         =       0x00004000              | 16kB

UserStart       =       MinRomSize 

/* Base Addresses */

RomBase         =       0x00c00000              	| were the rom is mapped to
TpuBase         =       0x00a00000              	| were the tpu is mapped to
| HDTBase         =       (RomBase+MinRomSize-HDTSize)| were the HDT ist mapped to

CS2             =       0x00e00000              | Memory map for various CS
CS4             =       0x00e00800
CS5             =       0x00e01000
CS8             =       0x00e01800      
CS9             =       0x00e02000
CS10            =       0x00e02800

/* Eyebot Platform */

LcdBase         =       CS2
OutBase         =       CS4
InBase          =       CS5
ParBase         =       CS8     
Ser1Base        =       CS9
Ser2Base        =       CS10

CamBase         =       CS8     

/* Eyebot Vehicle */

IOBase          =       CS4                     | Vehicle has a little different I/O


/* bits of the system status byte */

TASKING = 0     | multitasking on/off

/* system const save locations */
eofram	=	(240*4)
heapadr	=	(241*4)

FLASH_MAGIC = 0x11071971                                                                                             
