#ifndef  TYPES_H
#define  TYPES_H

/* C++ needs to know that types and declarations are C, not C++.  */
#ifdef	__cplusplus
# define __ROBIOS_BEGIN_DECLS	extern "C" {
# define __ROBIOS_END_DECLS	}
#else
# define __ROBIOS_BEGIN_DECLS
# define __ROBIOS_END_DECLS
#endif

__ROBIOS_BEGIN_DECLS

/* 10 WORD variables for the user can be stored into tpu ram to survive reset */
#define SAVEVAR0    0
#define SAVEVAR1    2        
#define SAVEVAR2    4
#define SAVEVAR3    6        
#define SAVEVAR4    8
#define SAVEVAR5   10        
#define SAVEVAR6   12
#define SAVEVAR7   14        
#define SAVEVAR8   16
#define SAVEVAR9   18        

/* 10 WORD variables for the OS can be stored into tpu ram to survive reset (see audio.s and system.s) */
#define SYSSAVEVAR0   20
#define SYSSAVEVAR1   22        
#define SYSSAVEVAR2   24
#define SYSSAVEVAR3   26        
#define SYSSAVEVAR4   28
#define SYSSAVEVAR5   30        
#define SYSSAVEVAR6   32
#define SYSSAVEVAR7   34        
#define SYSSAVEVAR8   36
#define SYSSAVEVAR9   38        


/* USRResident operation codes */
#define GET     0
#define SET     1

/* image is 80x60 but has a border of 1 pixel */
#define imagecolumns 82
#define imagerows 62

enum
{
  PSD_OUT_OF_RANGE = 9999 /* PSDGet() result if distance is unknown */
};

#if !defined(_BYTE)
#define _BYTE
typedef unsigned char BYTE;
#endif

#if !defined(_BOOL)
#define _BOOL
typedef unsigned char BOOL;
#define TRUE    1
#define FALSE   0
#define PERHAPS 2
#endif

#if!defined(NULL)
#define NULL    0
#endif

typedef BYTE image[imagerows][imagecolumns];
typedef BYTE colimage[imagerows][imagecolumns][3];

/* Hardware description table (HDT) types */
typedef short   TypeID;
typedef short   DeviceSemantics;
typedef int MotorHandle;
typedef int ServoHandle;
typedef int PSDHandle;
typedef int QuadHandle;
typedef int BumpHandle;
typedef int IRHandle;
typedef int VWHandle;

/* Drive (VW) types */
typedef float meterPerSec;
typedef float radPerSec;
typedef float meter;
typedef float radians;

typedef struct
{
  meter x;
  meter y;
  radians phi;
} PositionType;

typedef struct
{
  meterPerSec v;
  radPerSec w;
} SpeedType;

/* time datatype */
typedef struct
{
  int hrs;
  int mins;
  int secs;
  int ticks;
} timestamp;

/* tone datatype */
typedef struct
{
  int freq;
  int len;
} tone;

/* USER-IRQ datatypes */
typedef int TimerHandle;
typedef void (*TimerFnc)(void);

struct tcb;
struct sem;


/* RADIO communication */
enum
{
  MAXEYE    = 16, /* max no. of EyeBots in communication          */
  MSGMAXLEN = 35, /* max no. of payload bytes per message */

  /* Message types */
  TOKEN     = 0,
  OS        = 1,
  USER      = 2,
  SYNC      = 3,
  WILDCARD  = 4,
  ADDNEW    = 5,

  /* Addresses */
  BROADCAST = 127
};

typedef struct
{
  int interface;      /* SERIAL1, SERIAL2 or SERIAL3 */
  int speed;          /* SER9600,SER19200,SER38400,SER57600, SER115200 */
  int id;             /* machine id */
  int remoteOn;       /* nonzero if remote control is active */
  int imageTransfer;  /* if remote on: 0 off, 2 full, 1 reduced */
  int debug;          /* 0 off, 1..100 on with according wait time */
} RadioIOParameters;

typedef struct
{
  BYTE master;          /* EyeBot ID */
  BOOL active[MAXEYE];  /* shows who is active at the moment */

#if !defined(__mc68000__) /* Don't collect statistics on the robots */
  int token;
  int addnew;
  int sync;
  int wildcard;
  int os;
  int user;
  int unknown;
  int crcerr;
#endif
} RadioStatus;

__ROBIOS_END_DECLS

#endif
