/*
| ------------------------------------------------------------------------------
| Filename: hdtbiped.c
|
| Author:       Thomas Braunl  (braunl@ee.uwa.edu.au)
|
| Description: 
| -------
| HDT data for biped walker 
| ------------------------------------------------------------------------------
*/

#define VERSION 1.6             /* User specific version nr. just for inform. */
#define NAME "Johnny"           /* Unique platform name max. 10 chars,inform. */
#define ID   21                 /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"


/* Timer2, 20ms period, 0.7ms min, 1.7ms max */
servo_type servo0  = {2,  0, TIMER2, 20000, 700, 1700};
servo_type servo1  = {2,  1, TIMER2, 20000, 700, 1700};
servo_type servo2  = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo3  = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo4  = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo5  = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo6  = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7  = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8  = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9  = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 11, TIMER2, 20000, 700, 1700};
servo_type servo12 = {2, 12, TIMER2, 20000, 700, 1700};
servo_type servo13 = {2, 13, TIMER2, 20000, 700, 1700};
servo_type servo14 = {2, 14, TIMER2, 20000, 700, 1700};


info_type roboinfo = {0,WALKER,SER57600,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,25,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for six legged walker */

HDT_entry_type HDT[] =
{
    {SERVO,SERVO0,  "RHipT", (void *)&servo0},
    {SERVO,SERVO1,  "RHipB", (void *)&servo1},
    {SERVO,SERVO2,  "RKnee", (void *)&servo2},
    {SERVO,SERVO3,  "RAnkle",(void *)&servo3},
    {SERVO,SERVO4,  "Torso", (void *)&servo4},

    {SERVO,SERVO11, "LAnkle",(void *)&servo11},
    {SERVO,SERVO12, "LKnee", (void *)&servo12},
    {SERVO,SERVO13, "LHipB", (void *)&servo13},
    {SERVO,SERVO14, "LHipT", (void *)&servo14},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};


