/*
| -----------------------------------------------------------------------------
| Filename: hdtvehi.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (k_schmit@informatik.uni-kl.de)
| Description: 
| -------
| HDT data for Eyebot Vehicle
| -----------------------------------------------------------------------------
*/
#define VERSION 1.4              /* User specific version nr. just for information */
#define NAME "Klinsmann"         /* Unique name of the platform max. 10 chars, just for information */
#define ID   1                   /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"


/* right PSD-sensor, wall = white wall of maze on table (different for other obstacles) */

short dist0[128] = {60,60,60,60,60,60,62,65,68,71,            /*   1- 20 */
                    74,77,80,82,83,85,87,88,89,90,            /*  21- 40 */
                    92,93,95,96,98,99,101,102,104,105,        /*  41- 60 */
                    107,108,110,112,114,116,118,119,121,123,  /*  61- 80 */
                    126,128,130,133,135,138,141,144,147,150,  /*  81-100 */
                    153,156,160,164,168,172,176,180,184,189,  /* 101-120 */
                    195,200,205,210,217,222,228,237,246,254,  /* 121-140 */
                    262,270,280,290,303,316,330,348,367,387,  /* 141-160 */
                    450,650,830,900,999,999,999,999,999,999,  /* 161-180 */
                    999,999,999,999,999,999,999,999,999,999,  /* 181-200 */
                    999,999,999,999,999,999,999,999,999,999,  /* 201-220 */
                    999,999,999,999,999,999,999,999,999,999,  /* 221-240 */
                    999,999,999,999,999,999,999,999};         /* 241-256 */


BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

motor_type motor0 = {2,  0, TIMER1, 8191, (void*)(IOBase+2), 6, 7, (BYTE*)&motconv0};
motor_type motor1 = {2,  1, TIMER1, 8191, (void*)(IOBase+2), 4, 5, (BYTE*)0};
quad_type decoder0 = {0, 3, 2, MOTOR_LEFT,  3430, 2.0};
quad_type decoder1 = {0, 4, 5, MOTOR_RIGHT, 3430, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.144}};

bump_type bumper0 = {0, 6, TIMER2, EITHER};
bump_type bumper1 = {0, 7, TIMER2, EITHER};

ir_type   ir8 = {0, 8};
ir_type   ir9 = {0, 9};
ir_type   ir10 = {0, 10};
ir_type   ir11 = {0, 11};
ir_type   ir12 = {0, 12};
ir_type   ir13 = {0, 13};
ir_type   ir14 = {0, 14};

/* psd_type   psd0  = {0, 14, (BYTE*)(Ser1Base+6), 5, AL, (BYTE*)(Ser1Base+4), 0, AL, (short*)&dist0}; */
psd_type   psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
 

info_type roboinfo = {0,VEHICLE,SER57600,RTSCTS,SERIAL2,0,OFF,AUTOBRIGHTNESS,BATTERY_ON,25,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for Eyebot Vehicle                         */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD,QUAD_LEFT,"LEFT",(void *)&decoder0},
    {QUAD,QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {VW,VW_DRIVE,"Drive",(void *)&drive},
    {BUMP,BUMP_LEFT,"LEFT",(void *)&bumper0},
    {BUMP,BUMP_RIGHT,"RIGHT",(void *)&bumper1},

    {IR, IR_LF,"LF",(void *)&ir9},
    {IR, IR_LM,"LM",(void *)&ir8},
    {IR, IR_LB,"LB",(void *)&ir14},
    {IR, IR_RF,"RF",(void *)&ir10},
    {IR, IR_RM,"RM",(void *)&ir11},
    {IR, IR_RB,"RB",(void *)&ir12},
    {IR, IR_BA,"BA",(void *)&ir13},

    {PSD,PSD_LEFT, "LEFT",(void *)&psd2},
    {PSD,PSD_FRONT,"FRONT",(void *)&psd1},
    {PSD,PSD_RIGHT,"RIGHT",(void *)&psd0},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
