/*
| ------------------------------------------------------------------------------
| Filename: johnny.c
|
| Author:       Thomas Braunl  (braunl@ee.uwa.edu.au)
|
| Description: 
| -------
| HDT data for biped walker 
| ------------------------------------------------------------------------------
*/

#define VERSION 1.6             /* User specific version nr. just for inform. */
#define NAME "Johnny"           /* Unique platform name max. 10 chars,inform. */
#define ID   21                 /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* >700 is right and forward */
/* <700 is left and negative */

/* Timer2, 20ms period, 0.7ms min, 1.7ms max */           /* 128 is middle of servo's */
servo_type _RHipT_   = {2,  0, TIMER2, 20000, 660, 1660};   
servo_type _RHipB_   = {2,  1, TIMER2, 20000, 1676, 676};   
servo_type _RKnee_   = {2,  2, TIMER2, 20000, 1636, 636};   
servo_type _RAnkle_  = {2,  3, TIMER2, 20000, 708, 1708};  
servo_type _Torso_   = {2,  4, TIMER2, 20000, 1700, 700};   
servo_type servo5    = {2,  5, TIMER2, 20000, 700, 1700};   
servo_type servo6    = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7    = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8    = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9    = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo10   = {2, 10, TIMER2, 20000, 700, 1700};
servo_type _LAnkle_  = {2, 11, TIMER2, 20000, 1700, 700};   
servo_type _LKnee_   = {2, 12, TIMER2, 20000, 668, 1668};   
servo_type _LHipB_   = {2, 13, TIMER2, 20000, 692, 1692};   
servo_type _LHipT_   = {2, 14, TIMER2, 20000, 708, 1708};   


info_type roboinfo = {0,WALKER,SER115200,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,30,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for six legged walker */

HDT_entry_type HDT[] =
{
    {SERVO,SERVO0,  "RHipT", (void *)&_RHipT_},
    {SERVO,SERVO1,  "RHipB", (void *)&_RHipB_},
    {SERVO,SERVO2,  "RKnee", (void *)&_RKnee_},
    {SERVO,SERVO3,  "RAnkle",(void *)&_RAnkle_},
    {SERVO,SERVO4,  "Torso", (void *)&_Torso_},

    {SERVO,SERVO11, "LAnkle",(void *)&_LAnkle_},
    {SERVO,SERVO12, "LKnee", (void *)&_LKnee_},
    {SERVO,SERVO13, "LHipB", (void *)&_LHipB_},
    {SERVO,SERVO14, "LHipT", (void *)&_LHipT_},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};


