#define LINES 120
#define PIXELS_PER_LINE 160
#define VISIBLE_LINE 0xb6
#define BLANK_LINE 0x9d
#define BYTESIZE 8

#define CAM_VERSION 0x20

/** @name Bit locations of the various pins in the byte
	returned by OSReadParCTRL and OSReadParSR and of
	course OSWrite... */
/*@{*/  
/** QCK (00001000): (SR) pixel sample clock. */
#define QCK 0x08 /* look at OSReadParSR() doc before changing */
/** FST (00010000): (SR) Frame start signal.*/
#define FST 0x10
/** SIN (00000100): (CTRL) Frame timing reset. */
#define SIN 0x04
/** SCL (00000001): (CTRL) Serial bus clock. */
#define SCL 0x01
/** SDA (00001000): (CTRL) Serial bus data. */
#define SDA 0x08
/*@}*/ 

/** @name Serial initialization data */
/*@{*/ 
/** Write data byte (see under section labled 'Serial Interface' in the camera
    specification document). */ 
#define WRITE  	0X20 	

/** The address of the camera (with the read bit switched on). */
#define READ  	0X21

/** The address of the Setup 0 register in the VV 6300.  This register needs
    to be accessed in order to set the camera to 8 wire parallel output mode.*/
#define SETUP_0 0x10
/** The address of the Setup 4 register in the VV 6300.  This register needs
	to be accessed in order to set the QCK in free running mode and enable FST. */
#define SETUP_1 0x11
#define SETUP_4 0x14
/** The address of the Clock Divisor register.  This register need to be 
    accessed in order to change the clock divisor value.*/
#define CLK_DIV	0X25
/*@}*/ 

/** @name Camera initialization functions */
/*@{*/      
/** The VV 6300 defaults to transmitting in 4 wire parallel mode and its 
  * default clock divisor is 1.  For interfacing with the eyebot we require
  * the camera to transmit via 8 parallel wires and we also require the camera
  * to assume a clock divisor of 8.  This function initializes the camera to
  * these specific settings for the eyebot.
  */
int CMOSCAMInit (void);

/** Generates a start condition for sending serial data */
void startCondition (void);

/** Generates a stop condition for finalising serial data transmission */
void stopCondition (void);

/** Sends data through the serial interface of the eyebot to the VV 6300.  
  * The information is split into three main parts: a read/write byte, an 
  * address byte and a data byte.  
  */
int writeMessage (BYTE index, BYTE data);

/** Outputs a byte to the serial line.*/
int sendByte (BYTE value);

/** Reads a byte from the serial line.*/
BYTE readByte (void);

/** Set the SDA pin low */
void SDA_clear (void);

/** Set the SDA pin high -- should only be used without
	the camera connected */
void SDA_set (void);

/** Read the value of the SDA pin*/
int SDA_read (void);

/** Set the SCL pin low */
void SCL_clear (void);

/** Set the SCL pin high */
void SCL_set (void);

void acknowledge (void);

/** Function to display an error message and quit the program */
void error (char *string);

/*@}*/

