#ifndef _remote_h
#define _remote_h

#include "rs232.h" /* Needed for serial speed defines */

enum {
  /* Addresses */
  PCID            = 0,

  /* OS message subtypes */
  CODEClear       = 0,
  CODELine        = 1,
  CODEArea        = 2,
  CODESetPixel    = 3,
  CODEInvertPixel = 4, /* Use SetPixel (.., 2) instead */
  CODEMenu        = 5,
  CODEPutChar     = 6,
  CODEPutString   = 7,
  CODESetString   = 8,
  CODESetPos      = 9,
  CODEKeyPressed  = 10,
  CODEImage       = 11,
  CODEVWPosition  = 12,

  /* Default radio speed, used by remote and robots */
  /* SER9600,SER19200,SER38400,SER57600, SER115200 */
  DEFAULT_RADIO_SPEED = SER38400,
  DEFAULT_RADIO_BPS   = 38400
};

#endif
