/*
| -----------------------------------------------------------------------------
| Filename: hdtsocc.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
|               Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
| Description:
| -------
| HDT data for EyeBot MK3, UWA Sep. 1998, modified for soccerbot
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. for information */
#define NAME "E"              /* Unique name of the platform max. 10 chars, just info */
#define ID  5                 /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* PSD-sensor #0 (REP0-L), range 70 - 530 mm */
short distleft[128] =
  { 70,70,70,70,70,70,70,70,70,74, /* 1 - 20 */
    76,76,78,81,82,84,85,87,89,90, /* 21 - 40 */
    92,93,94,96,97,99,100,102,103,104, /* 41 - 60 */
    106,107,110,112,113,115,117,118,119,120, /* 61 - 80 */
    121,123,125,127,131,133,134,136,139,142, /* 81 - 100 */
    143,144,145,150,151,153,156,162,169,171, /* 101 - 120 */
    174,180,191,196,201,208,222,231,241,254, /* 121 - 140 */
    266,282,300,320,335,355,372,386,413,426, /* 141 - 160 */
    475,499,530,9999,9999,9999,9999,9999,9999,9999, /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */

/* PSD-sensor #1 (Front), range 81 - 332 mm */
short distfront[128] =
  { 81,81,81,81,81,81,81,81,81,87,                     /*   1 -  20 */
    89,90,92,93,94,95,96,97,98,99,                     /*  21 -  40 */
    101,103,103,104,105,106,108,111,112,112,           /*  41 -  60 */
    113,115,117,119,121,122,124,125,127,129,           /*  61 -  80 */
    132,135,136,137,138,143,146,149,150,151,           /*  81 - 100 */
    152,159,159,163,165,167,171,175,179,181,           /* 101 - 120 */
    187,189,192,203,200,209,212,220,223,231,           /* 121 - 140 */
    229,241,249,255,259,275,265,297,288,296,           /* 141 - 160 */
    304,318,318,334,332,9999,9999,9999,9999,9999,           /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,           /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,           /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999,           /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999};                  /* 241 - 256 */

/* PSD-sensor #2 (REP2-R), range 70 - 520 mm */
short distright[128] =
  { 70,70,70,70,70,70,70,70,76,79, /* 1 - 20 */
    80,80,80,80,82,84,86,88,91,92, /* 21 - 40 */
    94,96,98,100,101,103,105,106,108,110, /* 41 - 60 */
    111,113,115,116,118,119,121,123,125,127, /* 61 - 80 */
    129,131,133,135,137,139,142,144,146,148, /* 81 - 100 */
    151,153,156,158,161,164,168,171,174,177, /* 101 - 120 */
    180,184,188,192,196,200,205,210,215,220, /* 121 - 140 */
    226,233,240,246,253,266,270,280,302,316, /* 141 - 160 */
    323,350,363,380,395,440,475,520,9999,9999, /* 161 - 180 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */


BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
motor_type motor0 = {2,  1, TIMER1, 8191, (void*)OutBase, 3, 2, (BYTE*)&motconv0};
motor_type motor1 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
quad_type decoder0 = {0, 2, 3, MOTOR_LEFT,  3235, 2.0};
quad_type decoder1 = {0, 5, 4, MOTOR_RIGHT, 3235, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.084}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo11 = {2, 12, TIMER2, 20000, 810, 2300}; /* camera */
#if HAVE_KICKER
servo_type servo12 = {2, 13, TIMER2, 20000, 1750, 1500}; /* kicker */
#endif


/* PSD-infrared */
psd_type   psdleft   = {0, 14, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 4, AH, (short*)&distleft};
psd_type psdfront = {0, 14, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 4, AH, (short*)&distfront};
psd_type   psdright   = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 4, AH, (short*)&distright};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD, QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {QUAD, QUAD_LEFT,"LEFT",(void *)&decoder0},
    {VW,VW,"Drive",(void *)&drive},

    /* {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0}, */
    /* {IR, IR_LF,"LF",(void *)&ir0},             */

    {SERVO,SERVO11,"S11-C",(void *)&servo11},
#if HAVE_KICKER
    {SERVO,SERVO12,"S12-K",(void *)&servo12},
#endif

    {PSD,PSD_LEFT,      "P0-L", (void *)&psdleft},
    {PSD,PSD_FRONT,     "P1-F", (void *)&psdfront},
    {PSD,PSD_RIGHT,     "P2-R", (void *)&psdright},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
