/*---------------------------------------------------------------------------
  |
  |     Filename: globalsim.h
  |
  |     Author: Nicholas Tay
  |
  |     Description: User-visible simulator functions.
  |
  L--------------------------------------------------------------------------
  */

#ifndef _protos_h
#define _protos_h

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <sys/time.h>
#include <unistd.h>
#include <pthread.h>

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "const.h"
#include "kern.h"
#include "vw.h"
#include "hdt.h"
#include "types.h"
#include "improc.h"
#include "hdt_sem.h"

/********* Image processing functions - `improc.c' **********/

extern int IPLaplace (image *, image *);
extern int IPSobel (image *, image *);
extern int IPDither (image *, image *);
extern int IPDiffer (image *, image *, image *);
extern int IPColor2Grey (colimage *, image *);

/********* Key manipulation functions - `keysim.c' **********/

extern int KEYGetBuf (char *);
extern int KEYGet (void);
extern int KEYRead (void);
extern int KEYWait (int );

/********* LCD display functions - `lcdsim.c' ***************/

extern int LCDClear( void );
extern int LCDPutChar (char );
extern int LCDSetChar ( int ,int ,char );
extern int LCDPutString ( char *);
extern int LCDSetString ( int, int ,char *);
extern int LCDMode ( int );
extern int LCDGetPos(int *row, int *col);
extern int LCDSetPos (int, int);
extern int LCDPutColorGraphic(colimage *buf);
extern int LCDPutGraphic (image *);
extern int LCDPutImage ( BYTE *);
extern int LCDMenu (char *, char *, char *,char *);
extern int LCDMenuI (int , char *);
extern int LCDSetPixel (int,int,BOOL);
extern int LCDInvertPixel (int, int);
extern int LCDGetPixel (int, int);
extern int LCDLine(int, int, int, int, int);
extern int LCDArea(int, int, int, int, int );
extern int LCDPrintf(const char format[], ...);
extern int LCDSetPrintf(unsigned int row, unsigned int column, const char *fmt, ...);

/********* Camera functions - `camsim.c' ********************/

extern int CAMInit (int zoom);
extern int CAMRelease(void);
extern int CAMGetFrame ( image *);
extern int CAMGetColFrame ( colimage *, int convert);
extern int CAMSet (int ,int ,int );
extern int CAMGet (int *,int *,int *);
extern int CAMMode ( int );

/********* OS Functions - `OSmisc.c' *****************/

/*----------< UNIMPLEMENTED >--------------*/

extern int OSError(char *,int ,BOOL );
extern int OSMachineType(void);
BYTE OSMachineID (void);
char * OSMachineName (void);
extern int OSEnable ( void );
extern int OSDisable ( void );
extern int OSGetVar(int);
extern int OSPutVar(int, int);

extern int OSMTInit(BYTE);
extern int OSMTStatus (void);
extern struct tcb *OSSpawn(char *,int ,int ,int ,int );
extern int OSReady(struct tcb *);
extern int OSSuspend(struct tcb *);
extern int OSReschedule();
extern int OSYield();
extern int OSRun(struct tcb *);
extern int OSGetUID(struct tcb *);
extern int OSKill(struct tcb *);
extern int OSExit(int );
extern int OSPanic(char *);
extern int OSSleep(int );
extern int OSForbid();
extern int OSPermit();

extern void *HDTFindEntry(TypeID type_id,DeviceSemantics semantics);

/********* Semaphore Function - `OSmisc.c' ***************/

/*----------< UNIMPLEMENTED >--------------*/

extern int OSSemInit(struct sem *,int );
extern int OSSemP(struct sem *);
extern int OSSemV(struct sem *);

/*********** Timer Functions - `timer.c'  *****************/

extern int OSSetTime(int ,int ,int );
extern int OSGetTime(int *,int *,int *,int *);
extern int OSShowTime(void);
extern int OSGetCount(void);
extern int OSWait (int);

/*
  extern TimerHandle OSAttachTimer(int scale, TimerFnc function);
  extern int OSDetachTimer(TimerHandle handle)
  */


/*
  extern int AUPlaySample(char* sample);
  extern int AUCheckSample();
  extern int AURecordSample(BYTE* buf, long len, long freq);
  extern int AUCheckRecord();     */
extern int AUTone(int , int );
extern int AUBeep();
extern int AUCaptureMic();
extern int AUCheckTone();

/********* RS232  Functions - `rs232.c' *********/

extern int OSCheckInRS232 (int face) ;
extern int OSCheckOutRS232 (int face) ;
extern int OSFlushInRS232 (int face) ;
extern int OSFlushOutRS232 (int face) ;
extern int OSInitRS232 (int baudrate, int handshake, int face) ;
extern int OSRecvRS232 (char *chara, int face) ;
extern int OSSendCharRS232 (const char ch, const int face) ;
extern int OSSendRS232 (const char *ch, const int face) ;

/*
extern int OSDownload(char *name,int *bytes,int baud,int handshake,int face);
*/

/********* PSD Functions - `psd_drive.c' *********/

extern PSDHandle PSDInit(DeviceSemantics);
extern int PSDRelease();
extern int PSDStart(PSDHandle, BOOL);
extern int PSDStop();
extern BOOL PSDCheck();
extern int PSDGet(PSDHandle);
extern int PSDGetRaw(PSDHandle);

/********* Servo Functions - `psd_drive.c' *********/


extern ServoHandle SERVOInit(DeviceSemantics semantics);
extern int SERVORelease (ServoHandle handle);
extern int SERVOSet (ServoHandle handle,int angle);

/*
  extern MotorHandle MOTORInit(DeviceSemantics semantics);
  extern int MOTORRelease (MotorHandle handle)
  extern int MOTORDrive (MotorHandle handle,int speed);
  */
/*
  extern QuadHandle QuadInit(DeviceSemantics semantics);
  extern int QuadRelease(QuadHandle handle);
  extern int QuadReset(QuadHandle handle);
  extern int QuadRead(QuadHandle handle);
  extern DeviceSemantics QUADGetMotor(DeviceSemantics semantics);
  extern float QUADODORead(QuadHandle handle);
  extern int QUADODOReset(QuadHandle handle);
  */

/********* VW functions - `vw.c' **********/
extern VWHandle VWInit(DeviceSemantics, int);
extern int VWRelease(VWHandle);
extern int VWSetSpeed(VWHandle, meterPerSec, radPerSec);
extern int VWGetSpeed(VWHandle, SpeedType*);
extern int VWSetPosition(VWHandle, meter, meter, radians);
extern int VWGetPosition(VWHandle, PositionType*);
extern int VWStartControl(VWHandle, float, float, float, float);
extern int VWStopControl(VWHandle);
extern int VWDriveStraight(VWHandle, meter, meterPerSec);
extern int VWDriveTurn(VWHandle handle, radians, radPerSec);
extern int VWDriveCurve(VWHandle, meter, radians, meterPerSec);
extern float VWDriveRemain(VWHandle);
extern int VWDriveDone(VWHandle);
extern int VWDriveWait(VWHandle);
extern int VWStalled (VWHandle handle);

/********* Bumper functions - `bump.c' ************/

extern BumpHandle BUMPInit(DeviceSemantics);
extern int BUMPRelease(BumpHandle);
extern int BUMPCheck(BumpHandle , int *);

/********* Infra Red functions - `ir.c' ***********/

extern IRHandle IRInit(DeviceSemantics);
extern int IRRelease(IRHandle);
extern int IRRead(IRHandle);

/*
  extern BYTE OSReadInLatch(int latchnr);
  extern BYTE OSWriteOutLatch(int latchnr, BYTE mask, BYTE value);
  extern BYTE OSReadOutLatch(int latchnr);
  extern BYTE OSReadParData();
  extern void OSWriteParData(BYTE value);
  extern BYTE OSReadParSR();
  extern void OSWriteParCTRL(BYTE value);
  extern BYTE OSReadParCTRL();
  */

  extern int OSGetAD(int);
/*  extern int OSOffAD(int mode);
  */

/********* Radio communication functions - `radio.c' ***********/

extern int RADIOCheck(void);
extern int RADIOInit(void);
extern int RADIORecv(BYTE* id, int* bytesReceived, BYTE* buffer);
extern int RADIOSend(BYTE id, int byteCount, BYTE* buffer);
extern int RADIOTerm(void);
extern int RADIOGetIoctl(RadioIOParameters* radioParams);
extern int RADIOGetStatus(RadioStatus *s);
extern int RADIOSetIoctl(RadioIOParameters radioParams);

/********* Compass reading functions - `compass.c' ***********/

extern int COMPASSCalibrate (int mode) ;
extern int COMPASSCheck (void) ;
extern int COMPASSGet (void) ;
extern int COMPASSInit (DeviceSemantics semantics) ;
extern int COMPASSRelease (void) ;
extern int COMPASSStart (BOOL cycle) ;
extern int COMPASSStop (void) ;

#endif
