# EyeSim Parameter File
# Thomas Braunl - Ghee Ong - Nicholas Tay, UWA 1998

# order of names, sensors, etc. is arbitrary
# the keywords (in small letters) are:
# name, diameter, speed, turn, ir, psd, bump
# maze, world, debug, pause


name "EyeSpy7"     # max. 20 char 
diameter 80	   # robot diameter mm
speed    150 	   # max speed in cm/s
turn     600	   # max rotation in deg/s


#world /user/res/uwarobot/worlds/eyebot/table.wld	# specify world file to be opened
maze rob4.maz
# maze eg1.maz	   # specify maze file to be opened
debug off	   # debug flag (on/off)
pause on	   # pause flag (on/off)


# sensor definition: "psd", name, id-num, angle and distance from robot center, deviation angle
# id-num has to match file "hdt.h"
psd PSD_FRONT     -200    0 80  0 
psd PSD_FRONT2    -211    5 80 -5
psd PSD_LEFTDIAG  -203   45 80  0
psd PSD_RIGHTDIAG -204  -45 80  0
psd PSD_LEFT      -205   90 80  0
psd PSD_RIGHT     -210  -90 80  0
psd PSD_BACK      -212  180 80  0


# sensor definition: "ir", name, id-num, angle and distance from robot center, deviation angle
ir IR_LF -600    5 80 0
ir IR_LB -602   90 80 0
ir IR_RM -604  -45 80 0
ir IR_RB -605  -90 80 0
ir IR_RF -603   -5 80 0
ir IR_LM -601   45 80 0
ir IR_BA -606  180 80 0 


# sensor definition: "bump", name, id-num, from angle, to angle
# from angle --> to angle around robot, always counter-clockwise
bump BUMP_RIGHT -500  -180   0
bump BUMP_LEFT  -501     0 180


# error settings: "error", name, value  (using uniform random distribution)
# relation:  actual - value <= simulated <= actual + value
error linear 0  # no error
error rotate 0  # no error
error psd    5  # error is +/- 5mm
error ir     5  # error is +/- 5mm


# multiple robots
# "robots" no. of robots, followed by "start" start-position/-orientation
# x,y in mm and dir in radians for each robot
robots 1
