/********************************************************
| File:         irtv.h
|
| Author:       Michael Kapp
|
| Changed:      06-Apr-00
|
| Description:  IR remote control support
*********************************************************/


#ifndef IRTV_H
#define IRTV_H

#if defined(__cplusplus) && !defined(__ROBIOS_BEGIN_DECLS)
# define __ROBIOS_BEGIN_DECLS   extern "C" {
# define __ROBIOS_END_DECLS     }
#else
# define __ROBIOS_BEGIN_DECLS
# define __ROBIOS_END_DECLS
#endif

__ROBIOS_BEGIN_DECLS

/* Code types */

#define RAW_CODE            0               // normally only used by the analyzer
#define SPACE_CODE          1
#define PULSE_CODE          2
#define MANCHESTER_CODE     3


/* Modes */

#define DEFAULT_MODE        0
#define SLOPPY_MODE         1
#define REPCODE_MODE        2


/* Internal constants */

#define PULSE 0                             // "state" values
#define SPACE 1

#define MIN_PAUSE_MSEC 20                   // pause min length
#define MIN_SIGNAL_MSEC 2/10                // signal min length

#define START_TTL 20                        // default "time to live" value (1/100 sec)

#define MAX_BUFSIZE 4                       // max buffer size, must be >=3 (needed for raw code output)


/* Interface Functions */

int IRTVInit(int type, int length, int tog_mask, int inv_mask, int mode,
             int bufsize, int delay);
void IRTVTerm(void);
int IRTVPressed(void);
int IRTVRead(void);
int IRTVGet(void);
void IRTVFlush(void);
void IRTVGetRaw(int bits[2], int *count, int *duration, int *id, int *clock);
int IRTVDecodeRaw(const int bits[2], int count, int type);

__ROBIOS_END_DECLS

#endif
