#ifndef OMNI_H
#define OMNI_H

#include "types.h"


int MOTOR_Drive (MotorHandle handle,int speed) ; 
MotorHandle MOTOR_Init (DeviceSemantics semantics) ; 
int MOTOR_Release (MotorHandle handle) ; 
int OMNI_DriveCurve (VWHandle handle, meter delta_l, radians direction, radians delta_phi, radPerSec w,meterPerSec v) ; 
float OMNI_DriveRemain (VWHandle handle) ; 
int OMNI_DriveStraight (VWHandle handle, meterPerSec v, meter delta, radians d) ; 
int OMNI_GetSpeed (VWHandle handle, SpeedType* omni) ; 
int OMNI_SetSpeed (VWHandle handle, meterPerSec v, radians d, radPerSec w) ; 
int OMNI_TurnSpot (VWHandle handle, radians delta_phi, radPerSec w) ; 

DeviceSemantics QUAD_GetMotor (DeviceSemantics semantics) ; 
QuadHandle QUAD_Init (DeviceSemantics semantics) ; 
float QUAD_ODORead (QuadHandle handle) ; 
int QUAD_ODOReset (QuadHandle handle) ; 
int QUAD_Read (QuadHandle handle) ; 
int QUAD_Release (QuadHandle handle) ; 
int QUAD_Reset (QuadHandle handle) ; 


int OMNI_DriveDone (VWHandle handle) ; 
float OMNI_DriveRemain (VWHandle handle) ; 
int OMNI_DriveWait (VWHandle handle) ; 
int OMNI_GetPosition (VWHandle handle, PositionType* pos) ; 
VWHandle OMNI_Init (DeviceSemantics semantics, int Timescale) ; 
int OMNI_Release (VWHandle handle) ; 
int OMNI_SetPosition (VWHandle handle, meter x, meter y, radians phi) ; 
int OMNI_StartControl (VWHandle handle, float Vv, float Tv, float Vw, float Tw) ; 
int OMNI_StopControl (VWHandle handle) ; 

#endif







