/*
| ------------------------------------------------------------------------------
| Filename: hdtwalk.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
| Description: 
| -------
| HDT data for sixlegged walker 
| ------------------------------------------------------------------------------
*/

#define VERSION 1.1             /* User specific version nr. just for inform. */
#define NAME "Spider1"          /* Unique platform name max. 10 chars,inform. */
#define ID   2                  /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                                         60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                                         76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                                        103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                                        134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                                        195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                                        340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                                        830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                                        999, 999, 999, 999, 999, 999, 999, 999};

/* Timer2, 20ms period, 0.7ms min, 1.7ms max */
servo_type servo0 = {2,  0, TIMER2, 20000, 700, 1700};
servo_type servo1 = {2,  1, TIMER2, 20000, 700, 1700};
servo_type servo2 = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo3 = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo4 = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo5 = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo6 = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7 = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8 = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9 = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 11, TIMER2, 20000, 700, 1700};

psd_type   psd0   = {0, 12, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 6, AH, (short*)&dist0};
psd_type   psd1   = {0, 13, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 7, AH, (short*)&dist0};

/*
fumble_type fumble0 = {0, (BYTE*)InBase, 2};
fumble_type fumble1 = {0, (BYTE*)InBase, 3};
fumble_type fumble2 = {0, (BYTE*)InBase, 4};
fumble_type fumble3 = {0, (BYTE*)InBase, 5};
fumble_type fumble4 = {0, (BYTE*)InBase, 6};
fumble_type fumble5 = {0, (BYTE*)InBase, 7};
*/

info_type roboinfo = {0,WALKER,SER115200,RTSCTS,SERIAL1,0,OFF,NOAUTOBRIGHTNESS,BATTERY_OFF,30,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for six legged walker */

HDT_entry_type HDT[] =
{
    {SERVO,SER_LRFB,"LRFB",(void *)&servo0},
    {SERVO,SER_LRUD,"LRUD",(void *)&servo1},
    {SERVO,SER_RRFB,"RRFB",(void *)&servo2},
    {SERVO,SER_RRUD,"RRUD",(void *)&servo3},
    {SERVO,SER_LMFB,"LMFB",(void *)&servo4},
    {SERVO,SER_LMUD,"LMUD",(void *)&servo5},
    {SERVO,SER_RMFB,"RMFB",(void *)&servo6},
    {SERVO,SER_RMUD,"RMUD",(void *)&servo7},
    {SERVO,SER_LFFB,"LFFB",(void *)&servo8},
    {SERVO,SER_LFUD,"LFUD",(void *)&servo9},
    {SERVO,SER_RFFB,"RFFB",(void *)&servo10},
    {SERVO,SER_RFUD,"RFUD",(void *)&servo11},

    {PSD,PSD_FRONTLEFT,"FRONTL",(void *)&psd0},
    {PSD,PSD_FRONTRIGHT,"FRONTR",(void *)&psd1},

    /* please remove braces if fumble-sensors exist
    {FUMBLE,FUM_LR,"FUMLR",(void *)&fumble0},
    {FUMBLE,FUM_RR,"FUMRR",(void *)&fumble1},
    {FUMBLE,FUM_LM,"FUMLM",(void *)&fumble2},
    {FUMBLE,FUM_RM,"FUMRM",(void *)&fumble3},
    {FUMBLE,FUM_LF,"FUMLF",(void *)&fumble4},
    {FUMBLE,FUM_RF,"FUMRF",(void *)&fumble5},
    */

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
