;;
;; Parameters for the Pioneer robot
;; New motors
;;
AngleConvFactor  	0.0061359 ; radians per encoder count diff (2PI/1024)
DistConvFactor		0.05066   ; 5in*PI / 7875 counts (mm/count)
VelConvFactor           2.5332	  ; mm/sec / count  (DistConvFactor * 50)
RobotRadius	      220.0	  ; radius in mm
RobotDiagonal	       90.0	  ; half-height to diagonal of octagon
Holonomic 		1	  ; turns in own radius 
MaxRVelocity	      100.0	  ; degrees per second
MaxVelocity           400.0       ; mm per second

;;
;; Robot class, subclass
;;
Class	Pioneer
Subclass PSOS41m

;; These are for seven sonars: five front, two sides
;;
;; Sonar parameters
;;	SonarNum N is number of sonars
;;	SonarUnit I X Y TH is unit I (0 to N-1) description
;;   		X, Y are position of sonar in mm, TH is bearing in degrees
;;
RangeConvFactor		0.1734	; sonar range mm per 2 usec tick
;;
SonarNum 7
;;         #   x   y   th
;;-------------------------
SonarUnit  0  100 100  90
SonarUnit  1  120  80  30
SonarUnit  2  130  40  15
SonarUnit  3  130   0   0
SonarUnit  4  130 -40 -15
SonarUnit  5  120 -80 -30
SonarUnit  6  100 -100 -90
SonarUnit  7    0   0   0

;; Number of readings to keep in circular buffers
FrontBuffer 20
SideBuffer  40
