/*
* tpuregs.s - define addresses of TPU registers in 68332
* adjust the setting of tpumcr to reflect modmap bit
*/

tpumcr  =     0xfffffe00      | tpu module control register
tpucfg  =     tpumcr+2        | configuration register
dscr    =     tpumcr+4        | development support control register
dssr    =     tpumcr+6        | development support status register
tpuicr  =     tpumcr+8        | interrupt configuration register
tpuier  =     tpumcr+0xa      | interrupt enable register
cfsr0   =     tpumcr+0xc      | channel function select register 0
cfsr1   =     tpumcr+0xe      | channel function select register 1
cfsr2   =     tpumcr+0x10     | channel function select register 2
cfsr3   =     tpumcr+0x12     | channel function select register 3
hsr0    =     tpumcr+0x14     | host sequence register 0
hsr1    =     tpumcr+0x16     | host sequence register 1
hsrr0   =     tpumcr+0x18     | host service request register 0
hsrr1   =     tpumcr+0x1a     | host service request register 1
cpr0    =     tpumcr+0x1c     | channel priority register 0
cpr1    =     tpumcr+0x1e     | channel priority register 1
tpuisr  =     tpumcr+0x20     | interrupt status register
link    =     tpumcr+0x22
sglr    =     tpumcr+0x24     | service grant latch register
dcnr    =     tpumcr+0x26     | decoded channel number register
tpupram =     tpumcr+0x100    | start of tpu parameter RAM
