/*
| ------------------------------------------
| Filename: commdemo.c
|
| Author:   Thomas Braunl, braunl@ee.ua.edu.au, June 1998
|
| Description: 
| serial I/O over wireless link or cable
| -----------------------------------------
*/

#include "eyebot.h"
#include <stdio.h>

int r_remoteOn   = 1;
int r_id         = 0;
int r_imageTransfer = 0;
int r_radioDebug = 1;
int r_interface = SERIAL2;
int r_speed     = SER9600;

char str1[] = "0123456789";
char str2[] = "HELLOhello";
char str3[] = "....................";
char *s;

void main ()
{ char key, id, from;
  int  num, last = 0;

  /* disable input/output buffer */
  setvbuf (stdout,NULL,_IONBF,0); 
  setvbuf (stdin,NULL,_IONBF,0);  
  LCDClear();
  LCDMode(SCROLLING|NOCURSOR);

  printf("Wireless\n");
  LCDMenu("Snd","Deb","Ant","END");

	/* demo only: send 1->2, 2->1 */
	if (OSMachineID()==1) id=(char)2; else id=(char)1;

  RADIOInit();

  do
	{ switch(key=KEYRead())
    { case KEY1:
        if (last) s = str1; else s = str2;
				last = (last+1) %2;
				printf("Send %s\n", s);
        RADIOSend(id, 10, s);
        break;
      case KEY2:
        r_radioDebug = (r_radioDebug+1)%2;
        printf("Debug :%d\n", r_radioDebug);
        break;
      case KEY3:
        RADIOTerm();
        if (r_interface == SERIAL1) r_interface=SERIAL2;
				                       else r_interface=SERIAL1;
        printf("Rad<->Cab %d\n", r_interface);
        RADIOInit();
        break;
    }
		if (RADIOCheck())
		{ RADIORecv(&from, &num, str3);
		  printf("REC from %d (%d)\n", from, num);
			str3[num]=(char) 0;
		  printf("%s\n", str3);
		}
  } while(key!=KEY4);
	RADIOTerm();
}

