/* ---------------------------------------------------------------------------
| Filename:     react.c
|
| Authors:	Thomas Braunl   (braunl@ee.uwa.edu.au), Aug. 1997
|
| Description:  reaction test
| ------------------------------------------------------------------------- */

#include "eyebot.h"
#include <stdio.h>
#include <stdlib.h>

#define MAX_RAND  32767

void main()
{ int time, old,new;
  /** disable input/output buffer */
  setvbuf (stdout,NULL,_IONBF,0);
  setvbuf (stdin,NULL,_IONBF,0);
  LCDMode(SCROLLING|NOCURSOR);

  /** clear display and set display mode */
  printf(" Reaction Test\n");
  LCDMenu("GO"," "," "," ");
  KEYWait(ANYKEY);
  time = 100 + 700 * rand() / MAX_RAND; /* 1..8 s in sec/100 */
  LCDMenu(" "," "," "," ");

  OSWait(time);

  LCDMenu("HIT","HIT","HIT","HIT");
  if (KEYRead()) printf("no cheating !!\n");
   else {
    old = OSGetCount();
    KEYWait(ANYKEY);
    new = OSGetCount();
    printf("time: %1.2f\n", (float)(new-old) / 100.0);
   }

  LCDMenu(" "," "," ","END");
  KEYWait(KEY4);
}

