/* ---------------------------------------------------------------------------
| Filename:     etch.c
|
| Authors:	Thomas Braunl   (braunl@ee.uwa.edu.au)
|
| Description:  pixel operations resembling "etch a sketch"
| ------------------------------------------------------------------------- */

#include "eyebot.h"

void main()
{ int k;
  int x=0, y=0, xd=1, yd=1;

  /** clear display and set display mode */
  LCDClear();
  LCDMode(SCROLLING|NOCURSOR);
  LCDMenu("Y","X","+/-","END");

  while(KEY4 != (k=KEYRead())) {
    LCDSetPixel(y,x, 1);
    switch (k) {
      case KEY1: y = (y + yd +  64) %  64; break;
      case KEY2: x = (x + xd + 128) % 128; break;
      case KEY3: xd = -xd; yd = -yd; break;
    }
    LCDSetPos(1,5);
    LCDPrintf("y%3d:x%3d", y,x);
  }
}


